---
generated_at: 2026-01-21 10:42:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-HDRメタデータ未検出通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Extras.vb` 行144-181 - MKVInfo.MetadataHDRメソッド定義
- E-02: `Source/General/Extras.vb` 行150 - MediaInfo.GetVideo呼び出し
- E-03: `Source/General/Extras.vb` 行152 - PQ条件分岐
- E-04: `Source/General/Extras.vb` 行165 - HLG条件分岐
- E-05: `Source/General/Extras.vb` 行179 - MsgInfo呼び出し
- E-06: `Source/General/GlobalCommands.vb` 行583-596 - SaveMKVHDRコマンド
- E-07: `Source/General/General.vb` 行1216-1219 - MsgInfo関数定義
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行38 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「No HDR Metadata Key was Found」である | E-05, E-08 | ○ |
| C-02 | MKVInfo.MetadataHDR()メソッドで表示される | E-01, E-05 | ○ |
| C-03 | SaveMKVHDRコマンドから呼び出される | E-06 | ○ |
| C-04 | MediaInfo.GetVideoでtransfer_characteristicsを取得 | E-02 | ○ |
| C-05 | PQの場合はHDR10メタデータ追加処理 | E-03 | ○ |
| C-06 | HLGの場合はHLGメタデータ追加処理 | E-04 | ○ |
| C-07 | PQでもHLGでもない場合に通知表示 | E-05 | ○ |
| C-08 | MsgInfo関数を使用する | E-05, E-07 | ○ |
| C-09 | TaskIcon.Infoを使用する | E-07 | ○ |
| C-10 | ファイル存在チェックを行う | E-01 (行146-148) | ○ |
| C-11 | 同期方式で表示される | E-07 | ○ |
| C-12 | Extras使用時に表示 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Extras.vb の MKVInfo.MetadataHDRメソッドを確認
- [ ] MediaInfo.GetVideoの動作を確認
- [ ] transfer_characteristicsの値（PQ/HLG）を確認
