---
generated_at: 2026-01-21 19:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-MsgQuestion.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/General.vb` 行1261-1266（MsgQuestionオーバーロード1）
- E-02: `Source/General/General.vb` 行1268-1272（MsgQuestionオーバーロード2）
- E-03: `Source/UI/TaskDialog.vb` 行589-601（TaskButton列挙型）
- E-04: `Source/UI/TaskDialog.vb` 行313-323（Buttons WriteOnlyプロパティ）
- E-05: `Source/UI/TaskDialog.vb` 行493-508（GetDialogResultFromButton()）
- E-06: `Source/UI/TaskDialog.vb` 行91（TaskIcon.Question時のStockIcon取得）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行5（通知No.4の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MsgQuestionはMainModuleに定義されたグローバル関数 | E-01, E-02 | ○ |
| C-02 | MsgQuestionには2つのオーバーロードが存在 | E-01, E-02 | ○ |
| C-03 | buttonsパラメータのデフォルト値はOkCancel | E-01（行1263）, E-02（行1270） | ○ |
| C-04 | 戻り値はDialogResult列挙型 | E-01, E-02 | ○ |
| C-05 | TaskIcon.Questionが設定される | E-01（行1265）, E-02（行1271） | ○ |
| C-06 | TaskButtonはフラグ列挙型として定義 | E-03 | ○ |
| C-07 | OkCancel = OK Or Cancelで定義 | E-03（行597） | ○ |
| C-08 | YesNo = Yes Or Noで定義 | E-03（行598） | ○ |
| C-09 | YesNoCancel = YesNo Or Cancelで定義 | E-03（行599） | ○ |
| C-10 | Buttonsプロパティでフラグをループ処理 | E-04 | ○ |
| C-11 | HasFlagでボタン種別をチェック | E-04（行318） | ○ |
| C-12 | GetDialogResultFromButton()でTaskButton→DialogResult変換 | E-05 | ○ |
| C-13 | TaskIcon.QuestionでStockIconIdentifier.Helpを使用 | E-06 | ○ |
| C-14 | 通知カテゴリは「質問通知」である | E-07 | ○ |
| C-15 | Questionアイコンと各種ボタン選択可能 | E-07 | ○ |
| C-16 | ユーザー選択に応じてDialogResultが返される | E-01, E-02, E-05 | ○ |
| C-17 | モーダルダイアログとして表示 | E-04, ShowDialog()呼び出し | ○ |
| C-18 | 応答が必須（ブロッキング動作） | 同期的なShowDialog()呼び出し | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MsgQuestion関数の実装は明確で、根拠となるコードが確認済み
- 0: 低リスク - TaskButton列挙型の構造は明確に定義されている
- 0: 低リスク - ボタン設定処理のロジックはコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] MsgQuestion関数の2つのオーバーロードがGeneral.vb行1261-1272と一致するか確認
- [ ] TaskButton列挙型のフラグ定義がTaskDialog.vb行589-601と一致するか確認
- [ ] Buttonsプロパティのループ処理が正しく動作するか確認
- [ ] DialogResult戻り値のマッピングが正しいか確認
