---
generated_at: 2026-01-21 10:48:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-クリップボードコピー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/UI/TaskDialog.vb` 行454-467 - ShowCopyButtonプロパティ定義
- E-02: `Source/UI/TaskDialog.vb` 行457 - ボタンテキスト設定
- E-03: `Source/UI/TaskDialog.vb` 行459-464 - ClickActionハンドラ
- E-04: `Source/UI/TaskDialog.vb` 行462 - Clipboard.SetText呼び出し
- E-05: `Source/UI/TaskDialog.vb` 行463 - MsgInfo呼び出し
- E-06: `Source/UI/TaskDialog.vb` 行479-491 - GetTextメソッド定義
- E-07: `Source/General/General.vb` 行1216-1219 - MsgInfo関数定義
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行41 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Message was copied to clipboard.」である | E-05, E-08 | ○ |
| C-02 | Copy Messageボタンクリック時に表示される | E-01, E-03 | ○ |
| C-03 | Clipboard.SetTextでクリップボードにコピーする | E-04 | ○ |
| C-04 | GetText()でテキストを取得する | E-03, E-06 | ○ |
| C-05 | MsgInfo関数を使用する | E-05, E-07 | ○ |
| C-06 | TaskIcon.Infoを使用する | E-07 | ○ |
| C-07 | g.RunSTATaskでSTAスレッド実行 | E-03 (行460) | ○ |
| C-08 | TitleLabel.Text、Content、ExpandedContentを結合 | E-06 | ○ |
| C-09 | blCopyMessage.Visibleでボタン表示制御 | E-01 (行458) | ○ |
| C-10 | blCopyMessage.Textに"Copy Message"を設定 | E-02 | ○ |
| C-11 | 同期方式で表示される | E-07 | ○ |
| C-12 | TaskDialog使用時に表示 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] TaskDialog.vb の ShowCopyButtonプロパティを確認
- [ ] GetText()メソッドの実装を確認
- [ ] STAスレッドでのクリップボード操作を確認
