---
generated_at: 2026-01-21 19:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：41-キー割当変更通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/UI/CustomMenuEditor.vb` 行917
- E-02: `Source/UI/CustomMenuEditor.vb` 行896-925
- E-03: `Source/UI/CustomMenuEditor.vb` 行911-919
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行42
- E-05: `docs/code-to-docs/通知一覧/confidence-report_通知一覧.md` 行128

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Key detached and assigned」形式で表示 | E-01 (行917: MsgInfo呼び出し) | ○ |
| C-02 | CustomMenuEditorのtbHotkey_KeyDownで処理 | E-02 (イベントハンドラ定義) | ○ |
| C-03 | 重複キー検出時に既存割り当てをKeys.Noneに設定 | E-03 (行916: current.KeyData = Keys.None) | ○ |
| C-04 | KeysHelp.GetKeyStringでキー文字列を生成 | E-02 (行917: KeysHelp.GetKeyString呼び出し) | ○ |
| C-05 | メニュー項目名の末尾ピリオドを除去 | E-01 (TrimEnd("."c)使用) | ○ |
| C-06 | 通知カテゴリは「キー割当変更通知」 | E-04 (通知一覧での定義) | ○ |
| C-07 | MsgInfo関数で情報通知を表示 | E-01 (MsgInfo呼び出し確認) | ○ |
| C-08 | 修飾キーのみの入力はフィルタリング | E-02 (行898-900: ControlKey, Menu, ShiftKeyチェック) | ○ |
| C-09 | 同一キー再入力時はキー解除動作 | E-02 (行904-906: item.KeyData = Keys.None) | ○ |
| C-10 | TreeViewの全ノードを走査して重複チェック | E-03 (行911: tv.GetNodes使用) | ○ |
| C-11 | 通知はTaskDialogで表示される | E-05 (確認済み) | ○ |
| C-12 | 通知は同期で即時表示される | E-01 (BeginInvoke等なし、直接呼び出し) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージ形式がソースコードと一致している
- [x] トリガー条件（tbHotkey_KeyDown）が正確に記載されている
- [x] 重複キー検出ロジックが正確に記載されている
- [x] コードリーディングガイドの行番号が正確である
