---
generated_at: 2026-01-21 19:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-入力値エラー警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/UI/ExtenderProviders.vb` 行40
- E-02: `Source/UI/ExtenderProviders.vb` 行36-43
- E-03: `Source/UI/ExtenderProviders.vb` 行39
- E-04: `Source/UI/ExtenderProviders.vb` 行41
- E-05: `Source/UI/ExtenderProviders.vb` 行45-48
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行43

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「is no valid input」形式で表示 | E-01 (行40: MsgWarn呼び出し) | ○ |
| C-02 | ValidationProviderのValidatingイベントで処理 | E-02 (イベントハンドラ定義) | ○ |
| C-03 | Regex.IsMatchで正規表現パターン検証 | E-03 (行39: Regex.IsMatch呼び出し) | ○ |
| C-04 | バリデーション失敗時にデフォルト値へ復元 | E-04 (行41: c.Text = Defaults(c)) | ○ |
| C-05 | 入力値がダブルクォートで囲まれて表示 | E-01 ("""" + c.Text + """使用) | ○ |
| C-06 | Enterイベントでデフォルト値を記録 | E-05 (行47: Defaults(c) = c.Text) | ○ |
| C-07 | 通知カテゴリは「入力値エラー警告」 | E-06 (通知一覧での定義) | ○ |
| C-08 | MsgWarn関数で警告通知を表示 | E-01 (MsgWarn呼び出し確認) | ○ |
| C-09 | IExtenderProviderインターフェースを実装 | E-02 (クラス宣言確認) | ○ |
| C-10 | 通知は同期で即時表示される | E-01 (直接呼び出し) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージ形式がソースコードと一致している
- [x] トリガー条件（Validatingイベント）が正確に記載されている
- [x] デフォルト値復元ロジックが正確に記載されている
- [x] コードリーディングガイドの行番号が正確である
