---
generated_at: 2026-01-21 19:10:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-フォント未検出警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/UI/ImageUtils.vb` 行38
- E-02: `Source/UI/ImageUtils.vb` 行18-59
- E-03: `Source/UI/ImageUtils.vb` 行33-35
- E-04: `Source/UI/ImageUtils.vb` 行37-40
- E-05: `Source/UI/ImageUtils.vb` 行9-12
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行44

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは固定文言「Correct font was not found, using default instead!」 | E-01 (行38: MsgWarn呼び出し) | ○ |
| C-02 | ImageHelpクラスのGetSymbolImage関数で処理 | E-02 (関数定義確認) | ○ |
| C-03 | symbol > 61400でFontAwesome、それ以外でSegoe MDL2 Assets選択 | E-03 (If文確認) | ○ |
| C-04 | フォント未検出時にGenericSerifにフォールバック | E-04 (行39: family = FontFamily.GenericSerif) | ○ |
| C-05 | PrivateFontCollectionで静的にフォント管理 | E-05 (Coll変数定義) | ○ |
| C-06 | FontAwesome.ttfとSegoe-MDL2-Assets.ttfをロード | E-05 (AwesomePath, SegoePath定義) | ○ |
| C-07 | 通知カテゴリは「フォント未検出警告」 | E-06 (通知一覧での定義) | ○ |
| C-08 | MsgWarn関数で警告通知を表示 | E-01 (MsgWarn呼び出し確認) | ○ |
| C-09 | FontFilesExistでフォントファイル存在を事前確認 | E-05 (行12: FontFilesExist定義) | ○ |
| C-10 | FirstOrDefaultでフォントファミリーを検索 | E-03 (Coll.Families.FirstOrDefault使用) | ○ |
| C-11 | フォントファイル不在時はNothing返却 | E-02 (行23-25: If Not FontFilesExist Then Return Nothing) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージ形式がソースコードと一致している
- [x] フォント選択ロジック（61400境界値）が正確に記載されている
- [x] フォールバック動作が正確に記載されている
- [x] コードリーディングガイドの行番号が正確である
