---
generated_at: 2026-01-21 19:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-ヒント通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Documentation.vb` 行425-432
- E-02: `Source/General/Documentation.vb` 行429
- E-03: `Source/General/Documentation.vb` 行426
- E-04: `Source/General/Documentation.vb` 行428
- E-05: `Source/General/Documentation.vb` 行430
- E-06: `Source/Forms/MainForm.vb` 行5417-5426
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行45

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShowTip関数がDocumentationクラスに実装 | E-01 (関数定義確認) | ○ |
| C-02 | タイトル「Tip」でMsgInfo表示 | E-02 (行429: MsgInfo("Tip", message)) | ○ |
| C-03 | MD5ハッシュでメッセージを識別 | E-03 (行426: message.MD5Hash) | ○ |
| C-04 | s.Storage.GetBoolで表示済み確認 | E-04 (行428: s.Storage.GetBool(hash)) | ○ |
| C-05 | s.Storage.SetBoolで表示済み記録 | E-05 (行430: s.Storage.SetBool(hash, True)) | ○ |
| C-06 | 同一メッセージは一度のみ表示 | E-04, E-05 (GetBool/SetBoolの組み合わせ) | ○ |
| C-07 | MainForm.ShowAudioTipが呼び出し元の一例 | E-06 (Documentation.ShowTip呼び出し確認) | ○ |
| C-08 | ffmpegデコーダ/エンコーダ同時使用時の警告に使用 | E-06 (行5421: 条件確認) | ○ |
| C-09 | 通知カテゴリは「ヒント通知」 | E-07 (通知一覧での定義) | ○ |
| C-10 | MsgInfo関数で情報通知を表示 | E-02 (MsgInfo呼び出し確認) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] ShowTip関数の実装が正確に記載されている
- [x] MD5ハッシュによる重複抑止メカニズムが正確である
- [x] 呼び出し元の例（ShowAudioTip）が正確である
- [x] コードリーディングガイドの行番号が正確である
