---
generated_at: 2026-01-21 19:20:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-eac3to失敗エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/eac3toForm.vb` 行752
- E-02: `Source/Forms/eac3toForm.vb` 行748-757
- E-03: `Source/Forms/eac3toForm.vb` 行751
- E-04: `Source/Forms/eac3toForm.vb` 行753
- E-05: `Source/Forms/eac3toForm.vb` 行769-778
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行46

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「eac3to failed with error code {exitCode}」形式 | E-01 (行752: MsgError呼び出し) | ○ |
| C-02 | ExitCode <> 0の場合に通知表示 | E-02 (行748: If pr.ExitCode <> 0) | ○ |
| C-03 | BeginInvokeでUIスレッドにマーシャリング | E-03 (行751: BeginInvoke) | ○ |
| C-04 | エラー後にCancel処理実行 | E-04 (行753: Cancel()) | ○ |
| C-05 | OutputDataReceivedで標準出力を収集 | E-05 (イベントハンドラ定義) | ○ |
| C-06 | MsgError関数でエラー通知を表示 | E-01 (MsgError呼び出し確認) | ○ |
| C-07 | Output変数に出力を蓄積 | E-05 (行774: Output += e.Data + BR) | ○ |
| C-08 | 通知カテゴリは「eac3to失敗エラー」 | E-06 (通知一覧での定義) | ○ |
| C-09 | 終了コードが通知に含まれる | E-01 (exitCode変数使用) | ○ |
| C-10 | eac3toFormで処理される | E-02 (ファイル確認) | ○ |
| C-11 | Outputが詳細情報として表示される | E-01 (MsgError第2引数にOutput) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージ形式がソースコードと一致している
- [x] トリガー条件（ExitCode <> 0）が正確に記載されている
- [x] BeginInvokeによる非同期処理が正確に記載されている
- [x] コードリーディングガイドの行番号が正確である
