---
generated_at: 2026-01-21 19:25:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-eac3to空出力警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/eac3toForm.vb` 行786
- E-02: `Source/Forms/eac3toForm.vb` 行785-787
- E-03: `Source/Forms/eac3toForm.vb` 行780-829
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行47

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「eac3to output was empty」固定 | E-01 (行786: MsgWarn呼び出し) | ○ |
| C-02 | Output = ""の場合に通知表示 | E-02 (行785: If Output = "") | ○ |
| C-03 | Init処理で判定・通知される | E-03 (Init関数内の処理) | ○ |
| C-04 | 警告表示後にCancel処理実行 | E-02 (行787: Cancel()) | ○ |
| C-05 | MsgWarn関数で警告通知を表示 | E-01 (MsgWarn呼び出し確認) | ○ |
| C-06 | 通知カテゴリは「eac3to空出力警告」 | E-04 (通知一覧での定義) | ○ |
| C-07 | eac3toFormで処理される | E-03 (ファイル確認) | ○ |
| C-08 | eac3to正常終了後にInit処理が呼ばれる | E-02 (Analyze→Init呼び出しフロー) | ○ |
| C-09 | 3D検出より先に空出力チェックが実行される | E-02 (If-ElseIf順序確認) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージ形式がソースコードと一致している
- [x] トリガー条件（Output = ""）が正確に記載されている
- [x] Cancel処理が正確に記載されている
- [x] コードリーディングガイドの行番号が正確である
