---
generated_at: 2026-01-21 19:30:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-3D非対応エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/eac3toForm.vb` 行789
- E-02: `Source/Forms/eac3toForm.vb` 行788-790
- E-03: `Source/Forms/eac3toForm.vb` 行780-829
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行48

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「3D demuxing isn't supported.」固定 | E-01 (行789: MsgError呼び出し) | ○ |
| C-02 | ContainsAll("left eye", "right eye")で3D検出 | E-02 (行788: 判定条件) | ○ |
| C-03 | Init処理で判定・通知される | E-03 (Init関数内の処理) | ○ |
| C-04 | エラー表示後にCancel処理実行 | E-02 (行790: Cancel()) | ○ |
| C-05 | MsgError関数でエラー通知を表示 | E-01 (MsgError呼び出し確認) | ○ |
| C-06 | 通知カテゴリは「3D非対応エラー」 | E-04 (通知一覧での定義) | ○ |
| C-07 | eac3toFormで処理される | E-03 (ファイル確認) | ○ |
| C-08 | 空出力チェックの後に3D検出チェック | E-02 (ElseIf順序確認) | ○ |
| C-09 | 3D Blu-rayは左目/右目の2ストリーム | E-02 (left eye, right eye検出) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージ形式がソースコードと一致している
- [x] トリガー条件（ContainsAll）が正確に記載されている
- [x] Cancel処理が正確に記載されている
- [x] コードリーディングガイドの行番号が正確である
