---
generated_at: 2026-01-21 19:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-再起動要求通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm_ShowSettings.vb` 行515
- E-02: `Source/Forms/MainForm_ShowSettings.vb` 行514-516
- E-03: `Source/Forms/MainForm_ShowSettings.vb` 行522-524
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行50

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Please restart StaxRip.」固定 | E-01 (行515: MsgInfo呼び出し) | ○ |
| C-02 | restartId <> GetRestartId()で再起動必要判定 | E-02 (行514: If条件) | ○ |
| C-03 | GetRestartIdはs.AviSynthMode & s.VapourSynthModeを返す | E-03 (行523: Return文) | ○ |
| C-04 | MainForm_ShowSettingsで処理される | E-02 (ファイル確認) | ○ |
| C-05 | MsgInfo関数で情報通知を表示 | E-01 (MsgInfo呼び出し確認) | ○ |
| C-06 | 通知カテゴリは「再起動要求通知」 | E-04 (通知一覧での定義) | ○ |
| C-07 | 設定ダイアログOK後に判定実行 | E-02 (処理フロー確認) | ○ |
| C-08 | AviSynthModeが再起動判定に含まれる | E-03 (GetRestartId実装) | ○ |
| C-09 | VapourSynthModeが再起動判定に含まれる | E-03 (GetRestartId実装) | ○ |
| C-10 | 設定変更なしの場合は通知されない | E-02 (If条件で判定) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージ形式がソースコードと一致している
- [x] トリガー条件（GetRestartId比較）が正確に記載されている
- [x] GetRestartId関数の実装が正確に記載されている
- [x] コードリーディングガイドの行番号が正確である
