---
generated_at: 2026-01-21 19:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-プロファイル保存通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AudioForm.vb` 行1151
- E-02: `Source/Forms/AudioForm.vb` 行1142-1153
- E-03: `Source/Forms/CommandLineAudioEncoderForm.vb` 行531
- E-04: `Source/Forms/CommandLineAudioEncoderForm.vb` 行523-533
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行51

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「The profile was saved.」固定 | E-01, E-03 (両フォームで同一メッセージ) | ○ |
| C-02 | AudioFormのSaveProfileで処理される | E-02 (関数定義確認) | ○ |
| C-03 | CommandLineAudioEncoderFormのSaveProfileで処理される | E-04 (関数定義確認) | ○ |
| C-04 | ObjectHelp.GetCopyでプロファイルをコピー | E-02 (行1143), E-04 (行524) | ○ |
| C-05 | InputBox.Showでプロファイル名入力 | E-02 (行1144), E-04 (行525) | ○ |
| C-06 | name <> ""で保存実行判定 | E-02 (行1146), E-04 (行527) | ○ |
| C-07 | s.AudioProfiles.Addでプロファイル追加 | E-02 (行1149), E-04 (行529) | ○ |
| C-08 | g.SaveAudioProfilesで永続化 | E-02 (行1150), E-04 (行530) | ○ |
| C-09 | MsgInfo関数で情報通知を表示 | E-01, E-03 (MsgInfo呼び出し確認) | ○ |
| C-10 | 通知カテゴリは「プロファイル保存通知」 | E-05 (通知一覧での定義) | ○ |
| C-11 | AudioFormではgap.Clean()を呼び出す | E-02 (行1148) | ○ |
| C-12 | 名前未入力時は保存・通知されない | E-02, E-04 (If条件確認) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージ形式がソースコードと一致している
- [x] 両フォーム（AudioForm、CommandLineAudioEncoderForm）の処理が正確に記載されている
- [x] 保存処理フローが正確に記載されている
- [x] コードリーディングガイドの行番号が正確である
