---
generated_at: 2026-01-21 19:10:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-リカバリ保存失敗警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/MainForm.vb` 行2428-2499（OpenVideoSourceFiles関数）
- E-02: `Source/Forms/MainForm.vb` 行2442-2447（Try-Catchブロック）
- E-03: `Source/General/General.vb` 行1245-1255（MsgWarn関数）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行54（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知タイトルは「Recovery not saved!」である | E-02 (行2446), E-04 | ○ |
| C-02 | MsgWarn関数で警告を表示する | E-02 (行2446), E-03 | ○ |
| C-03 | SafeSerialization.Serializeの例外時にトリガーされる | E-02 (行2443, 2445-2446) | ○ |
| C-04 | 詳細内容にリカバリプロジェクトパスが含まれる | E-02 (行2446) | ○ |
| C-05 | recoverProjectPathはFolder.Temp + GUID + ".bin"で生成される | E-01 (行2432) | ○ |
| C-06 | 警告後も処理は続行される | E-01 (構造から確認) | ○ |
| C-07 | 成功時はDisposedハンドラが登録される | E-02 (行2444) | ○ |
| C-08 | OpenVideoSourceFiles関数がエントリーポイントである | E-01 | ○ |
| C-09 | ダイアログは同期表示される | E-03 | ○ |
| C-10 | TaskIcon.Warningが使用される | E-03 (行1250) | ○ |
| C-11 | MainForm使用時に発生する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] MainForm.vb行2442-2447のTry-Catchブロックを確認
- [ ] リカバリプロジェクトパスの生成ロジック（行2432）を確認
- [ ] 警告後の処理フローが続行されることを確認
