---
generated_at: 2026-01-21 19:35:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-アシスタントスキップ不可警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/MainForm.vb` 行4084-4182（AddJob関数 showJobsDialog版）
- E-02: `Source/Forms/MainForm.vb` 行4085-4088（CanIgnoreTipチェックとMsgWarn）
- E-03: `Source/General/General.vb` 行1245-1255（MsgWarn関数）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行59（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Assistant warning cannot be skipped.」である | E-02 (行4086), E-04 | ○ |
| C-02 | MsgWarn関数で警告を表示する | E-02 (行4086), E-03 | ○ |
| C-03 | CanIgnoreTipがFalseの場合にトリガーされる | E-02 (行4085) | ○ |
| C-04 | AddJob関数（showJobsDialog版）がエントリーポイントである | E-01 (行4084) | ○ |
| C-05 | 警告後はExit Subで処理が中断される | E-02 (行4087) | ○ |
| C-06 | スキップ可能な場合はSkippedAssistantTipsに追加される | E-01 (行4090-4092) | ○ |
| C-07 | VerifyRequirementsのチェックが後続処理で行われる | E-01 (行4094) | ○ |
| C-08 | ダイアログは同期表示される | E-03 | ○ |
| C-09 | TaskIcon.Warningが使用される | E-03 (行1250) | ○ |
| C-10 | MainForm使用時に発生する | E-04 | ○ |
| C-11 | CurrentAssistantTipKeyがSkippedリストに追加される | E-01 (行4091) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] MainForm.vb行4085-4088のCanIgnoreTipチェックロジックを確認
- [ ] CanIgnoreTipプロパティの定義と判定ロジックを確認
- [ ] SkippedAssistantTipsの使用箇所を確認
