---
generated_at: 2026-01-21 19:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-ジョブ追加通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/MainForm.vb` 行4197-4223（AddJob関数）
- E-02: `Source/Forms/MainForm.vb` 行4216-4218（showConfirmation時のMsgInfo）
- E-03: `Source/General/General.vb` 行1216-1220（MsgInfo関数）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行60（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Job added」である | E-02 (行4217), E-04 | ○ |
| C-02 | MsgInfo関数で情報を表示する | E-02 (行4217), E-03 | ○ |
| C-03 | showConfirmationがTrueの場合にトリガーされる | E-02 (行4216) | ○ |
| C-04 | AddJob関数がエントリーポイントである | E-01 | ○ |
| C-05 | JobManager.AddJobの後に呼び出される | E-01 (行4214, 4217) | ○ |
| C-06 | VerifyRequirementsチェックが先行する | E-01 (行4203) | ○ |
| C-07 | SaveProjectPathが呼び出される | E-01 (行4213) | ○ |
| C-08 | ダイアログは同期表示される | E-03 | ○ |
| C-09 | TaskIcon.Infoが使用される | E-03 (行1219) | ○ |
| C-10 | MainForm使用時に発生する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] MainForm.vb行4216-4218のshowConfirmationチェックロジックを確認
- [ ] MsgInfo関数の定義（General.vb行1216-1220）を確認
- [ ] JobManager.AddJobの呼び出し順序を確認
