---
generated_at: 2026-01-21 19:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Msg.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/General.vb` 行1274-1282（Msg関数定義）
- E-02: `Source/UI/TaskDialog.vb` 行580-587（TaskIcon列挙型）
- E-03: `Source/UI/TaskDialog.vb` 行589-601（TaskButton列挙型）
- E-04: `Source/UI/TaskDialog.vb` 行313-323（Buttons WriteOnlyプロパティ）
- E-05: `Source/UI/TaskDialog.vb` 行77-97（Init()メソッドでのIcon処理）
- E-06: `Source/General/General.vb` 行1216-1220（MsgInfo→Msg呼び出し）
- E-07: `Source/General/General.vb` 行1245-1255（MsgWarn→Msg呼び出し）
- E-08: `Source/General/General.vb` 行1261-1272（MsgQuestion→Msg呼び出し）
- E-09: `Source/General/General.vb` 行1257-1259（MsgOK→Msg呼び出し）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行7（通知No.6の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MsgはMainModuleに定義されたグローバル関数 | E-01 | ○ |
| C-02 | Msgはtitle, content, icon, buttonsの4パラメータを受け取る | E-01（行1274） | ○ |
| C-03 | 戻り値はDialogResult型 | E-01（行1274） | ○ |
| C-04 | TaskDialog(Of DialogResult)をUsingブロックで使用 | E-01（行1275） | ○ |
| C-05 | td.Icon = iconでアイコンを設定 | E-01（行1276） | ○ |
| C-06 | td.Title = titleでタイトルを設定 | E-01（行1277） | ○ |
| C-07 | td.Content = contentでコンテンツを設定 | E-01（行1278） | ○ |
| C-08 | td.Buttons = buttonsでボタンを設定 | E-01（行1279） | ○ |
| C-09 | td.Show()でダイアログを表示して結果を返す | E-01（行1280） | ○ |
| C-10 | TaskIconはNone/Info/Warning/Question/Error/Shieldを定義 | E-02 | ○ |
| C-11 | TaskButtonはフラグ列挙型として定義 | E-03 | ○ |
| C-12 | ButtonsプロパティでフラグをループしてAddButton呼び出し | E-04 | ○ |
| C-13 | Init()メソッドでアイコン画像を設定 | E-05 | ○ |
| C-14 | TaskIcon.InfoでStockIcon.Infoを取得 | E-05（行87） | ○ |
| C-15 | TaskIcon.WarningでStockIcon.Warningを取得 | E-05（行83） | ○ |
| C-16 | TaskIcon.QuestionでStockIcon.Helpを取得 | E-05（行91） | ○ |
| C-17 | MsgInfoがMsgを内部で呼び出す | E-06 | ○ |
| C-18 | MsgWarnがMsgを内部で呼び出す | E-07 | ○ |
| C-19 | MsgQuestion/MsgOKがMsgを内部で呼び出す | E-08, E-09 | ○ |
| C-20 | 通知カテゴリは「汎用通知」である | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Msg関数の実装は明確で、根拠となるコードが確認済み
- 0: 低リスク - TaskIcon/TaskButton列挙型の定義は明確
- 0: 低リスク - 他のメッセージ関数との関係性は明確

## 6) レビュアーチェックリスト（最小）
- [ ] Msg関数の定義がGeneral.vb行1274-1282と一致するか確認
- [ ] TaskIcon/TaskButton列挙型の定義がTaskDialog.vb行580-601と一致するか確認
- [ ] MsgInfo/MsgWarn/MsgQuestion/MsgOKがMsgを使用していることを確認
- [ ] MsgErrorのみ直接TaskDialog(Of String)を使用していることを確認
