---
generated_at: 2026-01-21 19:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-デフォルト復元通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/MainForm.vb` 行4280-4329（ShowFilterProfilesDialog関数）
- E-02: `Source/Forms/MainForm.vb` 行4297（MsgInfo呼び出し）
- E-03: `Source/Controls/CommandLineControl.vb` 行126-136（ShowDialogEx関数）
- E-04: `Source/Controls/CommandLineControl.vb` 行131（MsgInfo呼び出し）
- E-05: `Source/UI/Menu.vb` 行681-688（ShowScriptDialog関数）
- E-06: `Source/UI/Menu.vb` 行686（MsgInfo呼び出し）
- E-07: `Source/General/General.vb` 行1216-1220（MsgInfo関数）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行61（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Defaults were restored.」である | E-02, E-04, E-06, E-08 | ○ |
| C-02 | MsgInfo関数で情報を表示する | E-02, E-04, E-06, E-07 | ○ |
| C-03 | 複数箇所で使用されている | E-01, E-03, E-05, E-08 | ○ |
| C-04 | ShowFilterProfilesDialogで使用される | E-01, E-02 | ○ |
| C-05 | CommandLineControlで使用される | E-03, E-04 | ○ |
| C-06 | Menu.ShowScriptDialogで使用される | E-05, E-06 | ○ |
| C-07 | 確認ダイアログ後にトリガーされる | E-01 (行4295), E-03 (行129), E-05 (行684) | ○ |
| C-08 | デフォルト値が設定された後に表示される | E-01 (行4296-4297), E-03 (行130-131), E-05 (行685-686) | ○ |
| C-09 | ダイアログは同期表示される | E-07 | ○ |
| C-10 | TaskIcon.Infoが使用される | E-07 (行1219) | ○ |
| C-11 | キャンセル時は通知を表示しない | E-01 (条件分岐構造) | ○ |
| C-12 | 通知一覧では「複数箇所で使用」と記載されている | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] MainForm.vb行4297のMsgInfo呼び出しを確認
- [ ] CommandLineControl.vb行131のMsgInfo呼び出しを確認
- [ ] Menu.vb行686のMsgInfo呼び出しを確認
- [ ] 各箇所で確認ダイアログが先行することを確認
