---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：61-カテゴリ再作成警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **通知の優先度「中」**：コード上で優先度の明示的な定義が見つからない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行4314-4316（必須カテゴリチェックと警告表示）
- E-02: `Source/General/General.vb` 行1245-1255（MsgWarn関数定義）
- E-03: `Source/Forms/MainForm.vb` 行4303（ParseFilterProfilesIniContent呼び出し）
- E-04: `Source/Forms/MainForm.vb` 行4320-4326（プロファイル保存処理）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行62（通知No.61定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 必須カテゴリはSource, Crop, Resizeの3つ | E-01 | ○ |
| C-02 | MsgWarn関数で警告を表示する | E-01, E-02 | ○ |
| C-03 | カテゴリ欠落時に自動追加される | E-01 | ○ |
| C-04 | 通知メッセージは動的にカテゴリ名を含む | E-01 | ○ |
| C-05 | ダイアログアイコンはWarning | E-02 | ○ |
| C-06 | ボタンはOKのみ | E-02 | ○ |
| C-07 | フィルタプロファイル編集ダイアログでOKクリック時にトリガー | E-01 | ○ |
| C-08 | AviSynthProfiles/VapourSynthProfilesに保存される | E-04 | ○ |
| C-09 | パース処理はParseFilterProfilesIniContentで行う | E-03 | ○ |
| C-10 | 設定保存はg.SaveSettings()を呼び出す | E-04 | ○ |
| C-11 | 通知種別はアプリ内通知（モーダルダイアログ） | E-02 | ○ |
| C-12 | 送信方式は同期 | E-02 | ○ |
| C-13 | 通知の優先度は中 | **根拠なし** | △ |
| C-14 | onlyOnceフラグは使用されていない | E-01 | ○ |
| C-15 | 通知名は「カテゴリ再作成警告」 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 通知の優先度「中」の根拠が不明
  - 候補：開発者インタビュー / 設計ドキュメント / 内部仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 優先度の記載は設計書の補足情報であり、コードの動作には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] 必須カテゴリ（Source, Crop, Resize）の定義がコードと一致しているか確認
- [ ] MsgWarn関数のパラメータ解釈が正しいか確認
- [ ] プロファイル保存処理のフローが正しいか確認
