---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-字幕未検出通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行4467-4470（字幕トラック数チェックと通知表示）
- E-02: `Source/Forms/MainForm.vb` 行4464-4465（IDX拡張子判定とSubtitle.Create呼び出し）
- E-03: `Source/General/General.vb` 行1216-1220（MsgInfo関数定義）
- E-04: `Source/Forms/MainForm.vb` 行4458-4461（ShowHardcodedSubtitleDialogメソッド定義）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行63（通知No.62定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IDX形式のファイル選択時にのみ字幕トラック数チェックが行われる | E-02 | ○ |
| C-02 | MsgInfo関数で情報通知を表示する | E-01, E-03 | ○ |
| C-03 | 通知メッセージは「No subtitles found.」 | E-01 | ○ |
| C-04 | 字幕トラック数が0の場合に通知が表示される | E-01 | ○ |
| C-05 | ダイアログアイコンはInfo | E-03 | ○ |
| C-06 | ボタンはOKのみ | E-03 | ○ |
| C-07 | 通知後はExit Subで処理を終了する | E-01 | ○ |
| C-08 | Subtitle.Createメソッドでパースを行う | E-02 | ○ |
| C-09 | 通知種別はアプリ内通知（モーダルダイアログ） | E-03 | ○ |
| C-10 | ShowHardcodedSubtitleDialogがエントリーポイント | E-04 | ○ |
| C-11 | 字幕が見つかった場合は言語選択ダイアログを表示 | E-01 | ○ |
| C-12 | 通知名は「字幕未検出通知」 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コードとの整合性が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] Subtitle.Createメソッドの実装詳細を確認（エラー時の動作）
- [ ] IDX以外の字幕形式の処理パスを確認
- [ ] 通知メッセージの多言語対応状況を確認（必要に応じて）
