---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-手動マージ案内通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行5127-5133（proc.Start()と例外処理）
- E-02: `Source/Forms/MainForm.vb` 行5131（MsgInfo呼び出し）
- E-03: `Source/Forms/MainForm.vb` 行5100-5157（ShowOpenSourceMergeFilesDialogメソッド全体）
- E-04: `Source/Forms/MainForm.vb` 行5111-5114（mpg/vobファイル判定）
- E-05: `Source/General/General.vb` 行1216-1220（MsgInfo関数定義）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行65（通知No.64定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShowOpenSourceMergeFilesDialogメソッドでマージ処理 | E-03 | ○ |
| C-02 | MsgInfo関数で情報通知を表示する | E-02, E-05 | ○ |
| C-03 | タイトルは「Manual Merging」 | E-02 | ○ |
| C-04 | メッセージに手動マージとサポートフォーラム案内を含む | E-02 | ○ |
| C-05 | ダイアログアイコンはInfo | E-05 | ○ |
| C-06 | ボタンはOKのみ | E-05 | ○ |
| C-07 | proc.Start()で例外発生時にトリガー | E-01 | ○ |
| C-08 | mpg/vobファイルは別処理（OpenVideoSourceFiles） | E-04 | ○ |
| C-09 | 通知後にAbortExceptionがスローされる | E-01 | ○ |
| C-10 | g.ShowExceptionで詳細な例外情報も表示される | E-01 | ○ |
| C-11 | mkvmergeツールを使用 | E-03 | ○ |
| C-12 | Procクラスで外部プロセスを管理 | E-01, E-03 | ○ |
| C-13 | 通知種別はアプリ内通知（モーダルダイアログ） | E-05 | ○ |
| C-14 | MediaInfoでログ出力を行う | E-03 | ○ |
| C-15 | 通知名は「手動マージ案内通知」 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コードとの整合性が確認できる
- 注意事項：メッセージ内の `]` はタイポの可能性があるが、コード上の事実として記載

## 6) レビュアーチェックリスト（最小）
- [ ] mkvmergeが正常にインストールされているか確認
- [ ] AbortException後の処理フローを確認
- [ ] メッセージ内の `]` がタイポかどうか開発者に確認
