---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-固定ドライブエラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行5265-5268（IsFixedDriveチェックとMsgError呼び出し）
- E-02: `Source/General/General.vb` 行1222-1241（MsgError関数定義）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行67（通知No.66定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | g.IsFixedDriveで固定ドライブ判定を行う | E-01 | ○ |
| C-02 | MsgError関数でエラー通知を表示する | E-01, E-02 | ○ |
| C-03 | メッセージは「Only fixed local drives are supported as temp dir.」 | E-01 | ○ |
| C-04 | ダイアログアイコンはError | E-02 | ○ |
| C-05 | ボタンはOKのみ | E-02 | ○ |
| C-06 | コピーボタンが表示される | E-02 | ○ |
| C-07 | 通知後はExit Subで処理中断 | E-01 | ○ |
| C-08 | 一時フォルダ作成成功後にチェックが実行される | E-01 | ○ |
| C-09 | 通知種別はアプリ内通知（モーダルダイアログ） | E-02 | ○ |
| C-10 | 送信方式は同期 | E-02 | ○ |
| C-11 | form.OutputFolderを判定対象とする | E-01 | ○ |
| C-12 | Blu-rayデマックス処理時にトリガー | E-01 | ○ |
| C-13 | 通知名は「固定ドライブエラー」 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コードとの整合性が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] IsFixedDriveメソッドの実装詳細を確認
- [ ] DriveType列挙値の網羅性を確認
- [ ] ネットワークドライブやVHDの判定が正しいか確認
