---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-無効フォーマット警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行5627-5641（形式チェックとMsgWarn呼び出し）
- E-02: `Source/Forms/MainForm.vb` 行5615-5642（TargetImageMenuClickメソッド全体）
- E-03: `Source/General/General.vb` 行1245-1255（MsgWarn関数定義）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行68（通知No.67定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TargetImageMenuClickメソッドで値を処理 | E-02 | ○ |
| C-02 | MsgWarn関数で警告を表示する | E-01, E-03 | ○ |
| C-03 | メッセージは「Invalid format」 | E-01 | ○ |
| C-04 | value.IsInt()で整数チェック | E-01 | ○ |
| C-05 | 「x」を含む場合はSplitNoEmptyAndWhiteSpaceで分割 | E-01 | ○ |
| C-06 | 分割後2要素かつ両方整数の場合はSetTargetImageSize呼び出し | E-01 | ○ |
| C-07 | ダイアログアイコンはWarning | E-03 | ○ |
| C-08 | ボタンはOKのみ | E-03 | ○ |
| C-09 | 通知種別はアプリ内通知（モーダルダイアログ） | E-03 | ○ |
| C-10 | Macro.ExpandとMacro.ExpandGUIで前処理 | E-02 | ○ |
| C-11 | ユーザーキャンセル時はExit Sub | E-02 | ○ |
| C-12 | 整数の場合はSetTargetImageSizeByPixel呼び出し | E-01 | ○ |
| C-13 | 通知名は「無効フォーマット警告」 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コードとの整合性が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] IsInt()拡張メソッドの実装詳細を確認
- [ ] SplitNoEmptyAndWhiteSpace()の動作を確認
- [ ] 有効な入力形式のドキュメント化状況を確認
