---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-パラメータ無効エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行5681-5696（UpdateSourceParametersメソッド全体）
- E-02: `Source/Forms/MainForm.vb` 行5692-5695（Catchブロックと通知表示）
- E-03: `Source/General/General.vb` 行1222-1241（MsgError関数定義）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行69（通知No.68定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UpdateSourceParametersメソッドでソースパラメータ更新 | E-01 | ○ |
| C-02 | MsgError関数でエラー通知を表示する | E-02, E-03 | ○ |
| C-03 | タイトルは「Source filter returned invalid parameters」 | E-02 | ○ |
| C-04 | 本文にスクリプト内容が表示される（GetFullScript） | E-02 | ○ |
| C-05 | Try-Catchブロックで例外をキャッチ | E-01, E-02 | ○ |
| C-06 | 通知後にAbortExceptionがスローされる | E-02 | ○ |
| C-07 | ダイアログアイコンはError | E-03 | ○ |
| C-08 | ボタンはOKのみ | E-03 | ○ |
| C-09 | コピーボタンが表示される | E-03 | ○ |
| C-10 | p.SourceScriptがNullの場合はExit Sub | E-01 | ○ |
| C-11 | p.SourceScript.GetInfo()でビデオ情報取得 | E-01 | ○ |
| C-12 | Width, Height, Seconds, FrameRate, Framesを設定予定 | E-01 | ○ |
| C-13 | 通知種別はアプリ内通知（モーダルダイアログ） | E-03 | ○ |
| C-14 | 送信方式は同期 | E-03 | ○ |
| C-15 | 通知名は「パラメータ無効エラー」 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コードとの整合性が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] GetInfo()メソッドの例外発生条件を確認
- [ ] AbortException後のリソース解放が適切か確認
- [ ] スクリプト内容のエスケープ処理を確認
