---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-AviSynth未検出エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特になし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行5933-5936（AviSynthチェックと通知表示）
- E-02: `Source/Video/FrameServer.vb` 行457-467（GetAviSynthInstallPathメソッド）
- E-03: `Source/Video/FrameServer.vb` 行479-481（IsAviSynthPortableプロパティ）
- E-04: `Source/Video/FrameServer.vb` 行588-592（FrameServerMode列挙型）
- E-05: `Source/General/General.vb` 行1222-1241（MsgError関数定義）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行70（通知No.69定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OnActivatedイベントでチェックが実行される | E-01 | ○ |
| C-02 | MsgError関数でエラー通知を表示する | E-01, E-05 | ○ |
| C-03 | メッセージに「using portable mode instead」を含む | E-01 | ○ |
| C-04 | FrameServerHelp.IsAviSynthPortableでポータブルモード判定 | E-01, E-03 | ○ |
| C-05 | FrameServerHelp.GetAviSynthInstallPath()でインストールパス取得 | E-01, E-02 | ○ |
| C-06 | 通知後にs.AviSynthMode = FrameServerMode.Portableに設定 | E-01 | ○ |
| C-07 | レジストリのCLSIDキーからパスを取得 | E-02 | ○ |
| C-08 | ダイアログアイコンはError | E-05 | ○ |
| C-09 | ボタンはOKのみ | E-05 | ○ |
| C-10 | コピーボタンが表示される | E-05 | ○ |
| C-11 | 通知種別はアプリ内通知（モーダルダイアログ） | E-05 | ○ |
| C-12 | 送信方式は同期 | E-05 | ○ |
| C-13 | FrameServerMode列挙型にPortable/Installed/VFWがある | E-04 | ○ |
| C-14 | アプリケーション起動時（OnActivated）にトリガー | E-01 | ○ |
| C-15 | 通知名は「AviSynth未検出エラー」 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コードとの整合性が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] レジストリキーのCLSIDが正しいか確認
- [ ] System32パスの結合ロジックを確認
- [ ] ポータブルモードへの自動切替後の動作を確認
