---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：71-Windows 7互換性警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行6087-6092（CheckForWindows7メソッド）
- E-02: `Source/General/General.vb` 行1245-1252（MsgWarnメソッド）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行72（通知No.71定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知タイトルは「Compatibility problem!」である | E-01 (行6089) | ○ |
| C-02 | MsgWarn関数を使用して警告表示する | E-01 (行6089) | ○ |
| C-03 | OSメジャーバージョンが7の場合にトリガーされる | E-01 (行6088) | ○ |
| C-04 | s.ShowWindows7Warningフラグで表示制御される | E-01 (行6088, 6091) | ○ |
| C-05 | 表示後にShowWindows7WarningがFalseに設定される | E-01 (行6091) | ○ |
| C-06 | 影響ツールはMKVToolNixとPythonである | E-01 (行6089) | ○ |
| C-07 | Discordサーバーへの参加を案内している | E-01 (行6089) | ○ |
| C-08 | MsgWarnはTaskIcon.Warningを使用する | E-02 (行1245-1252) | ○ |
| C-09 | 通知カテゴリは警告通知である | E-03 | ○ |
| C-10 | 通知種別はアプリ内通知（タスクダイアログ）である | E-02 | ○ |
| C-11 | MainFormで使用される | E-03 | ○ |
| C-12 | 初回起動時のみ表示される | E-01 (行6091) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] CheckForWindows7メソッドの呼び出しタイミングを確認
- [ ] 影響ツール一覧が最新であることを確認
- [ ] Discordサーバーの案内が適切であることを確認
