---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-必須ツール全正常通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AppsForm.vb` 行920-938（miStatusRequired_Clickメソッド）
- E-02: `Source/General/General.vb` 行1216-1220（MsgInfoメソッド）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行74（通知No.73定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知タイトルは「OK!」である | E-01 (行934) | ○ |
| C-02 | 本文は「All required tools have OK status!」である | E-01 (行934) | ○ |
| C-03 | MsgInfo関数を使用して表示する | E-01 (行934) | ○ |
| C-04 | Ctrl+Yショートカットで実行可能 | E-01 (Designer部分行263) | ○ |
| C-05 | Package.Itemsをループしてステータスチェック | E-01 (行924-931) | ○ |
| C-06 | pack.Requiredでフィルタリングする | E-01 (行927) | ○ |
| C-07 | GetStatusが空かつRequired=Trueの場合のみ正常 | E-01 (行927) | ○ |
| C-08 | 問題がある必須ツールがある場合は別メッセージ | E-01 (行935-936) | ○ |
| C-09 | AppsForm画面で使用される | E-03 | ○ |
| C-10 | 通知カテゴリは情報通知である | E-03 | ○ |
| C-11 | MsgInfoはTaskIcon.Infoを使用する | E-02 (行1219) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Package.Requiredプロパティの設定基準を確認
- [ ] miStatusRequired_Clickのショートカットキーが正しいことを確認
- [ ] 全ツールチェック(miStatus)と必須ツールチェック(miStatusRequired)の違いを確認
