---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-カスタムパス禁止エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AppsForm.vb` 行940-965（miBrowsePath_Clickメソッド）
- E-02: `Source/Forms/AppsForm.vb` 行992-1061（Everythingメソッド）
- E-03: `Source/General/General.vb` 行1222-1241（MsgErrorメソッド）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行75（通知No.74定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エラーメッセージは「Custom paths within the startup folder are not permitted」 | E-01 (行955), E-02 (行1048) | ○ |
| C-02 | MsgError関数を使用して表示する | E-01 (行955), E-02 (行1048) | ○ |
| C-03 | Edit Path経由では詳細メッセージが表示される | E-01 (行955-957) | ○ |
| C-04 | Find Path経由では簡潔なメッセージが表示される | E-02 (行1048) | ○ |
| C-05 | s.AllowCustomPathsInStartupFolderでバイパス可能 | E-01 (行951), E-02 (行1044) | ○ |
| C-06 | Folder.Startup内パスがチェック対象 | E-01 (行952), E-02 (行1045) | ○ |
| C-07 | Folder.Settings内は例外として許可 | E-01 (行953), E-02 (行1046) | ○ |
| C-08 | Ctrl+Pショートカットで Edit Path 実行可能 | E-01 (Designer部分行182) | ○ |
| C-09 | Ctrl+Fショートカットで Find Path 実行可能 | E-01 (Designer部分行191) | ○ |
| C-10 | AppsForm画面で使用される | E-04 | ○ |
| C-11 | 通知カテゴリはエラー通知である | E-04 | ○ |
| C-12 | エラー時は処理が中断される（Exit Sub） | E-01 (行958), E-02 (行1049) | ○ |
| C-13 | ToLowerExで大文字小文字を無視して比較 | E-01 (行952), E-02 (行1045) | ○ |
| C-14 | StartsWithExでパスの開始部分を比較 | E-01 (行952), E-02 (行1045) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Folder.StartupとFolder.Settingsのパス取得ロジックを確認
- [ ] AllowCustomPathsInStartupFolder設定のデフォルト値を確認
- [ ] Edit PathとFind Pathのメッセージの違いが意図的かを確認
