---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-カスタムパス未定義通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AppsForm.vb` 行967-986（miClearCustomPath_Clickメソッド）
- E-02: `Source/General/General.vb` 行1216-1220（MsgInfoメソッド）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行76（通知No.75定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージは「No custom paths defined.」である | E-01 (行984) | ○ |
| C-02 | MsgInfo関数を使用して表示する | E-01 (行984) | ○ |
| C-03 | Ctrl+Xショートカットで実行可能 | E-01 (Designer部分行200) | ○ |
| C-04 | GetStoredPath()でカスタムパスをチェック | E-01 (行968) | ○ |
| C-05 | Whereでフィルタリングする | E-01 (行968) | ○ |
| C-06 | Count > 0 の場合は選択ダイアログを表示 | E-01 (行970-982) | ○ |
| C-07 | Count = 0 の場合にこの通知が表示される | E-01 (行983-985) | ○ |
| C-08 | AppsForm画面で使用される | E-03 | ○ |
| C-09 | 通知カテゴリは情報通知である | E-03 | ○ |
| C-10 | MsgInfoはTaskIcon.Infoを使用する | E-02 (行1219) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GetStoredPathの戻り値の仕様を確認
- [ ] miClearPaths（miClearCustomPath_Click）のショートカットキーが正しいことを確認
- [ ] カスタムパスが存在する場合のTaskDialogの動作を確認
