---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-パスコピー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AppsForm.vb` 行1150-1153（miCopyPath_Clickメソッド）
- E-02: `Source/Forms/AppsForm.vb` 行527（ShowActivePackageでのmiCopyPath.Enabled制御）
- E-03: `Source/General/General.vb` 行1216-1220（MsgInfoメソッド）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行80（通知No.79定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージは「The path was copied to the clipboard.」である | E-01 (行1152) | ○ |
| C-02 | MsgInfo関数を使用して表示する | E-01 (行1152) | ○ |
| C-03 | Clipboard.SetTextでパスをコピー | E-01 (行1151) | ○ |
| C-04 | CurrentPackage.Pathをコピー対象とする | E-01 (行1151) | ○ |
| C-05 | ショートカットキーは設定されていない | E-01 (Designer部分行208-210) | ○ |
| C-06 | miCopyPath.Enabled = path <> ""で制御 | E-02 | ○ |
| C-07 | AppsForm画面で使用される | E-04 | ○ |
| C-08 | 通知カテゴリは情報通知である | E-04 | ○ |
| C-09 | MsgInfoはTaskIcon.Infoを使用する | E-03 (行1219) | ○ |
| C-10 | コピー後に通知が表示される（順序） | E-01 (行1151-1152) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] CurrentPackage.Pathの値が正しく取得されていることを確認
- [ ] Clipboard.SetTextの例外処理を確認（必要に応じて）
- [ ] miCopyPath.Enabledの制御がShowActivePackageで行われていることを確認
