---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：81-PATH削除通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AppsForm.vb` 行1155-1194（miPATHEnvVar_Clickメソッド）
- E-02: `Source/Forms/AppsForm.vb` 行1179-1186（Remove処理ブロック）
- E-03: `Source/Forms/AppsForm.vb` 行1183（MsgInfo呼び出し）
- E-04: `Source/Forms/AppsForm.vb` 行1158-1159（プラットフォーム判定）
- E-05: `Docs/code-to-docs/通知一覧/通知一覧.csv` 行82（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Folder was removed from PATH」である | E-03, E-05 | ○ |
| C-02 | AppsFormのmiPATHEnvVar_Clickメソッドがエントリーポイントである | E-01 | ○ |
| C-03 | MsgInfo関数で情報通知として表示される | E-03 | ○ |
| C-04 | WindowsではEnvironmentVariableTarget.Userを使用する | E-04 | ○ |
| C-05 | 非WindowsではEnvironmentVariableTarget.Processを使用する | E-04 | ○ |
| C-06 | フォルダがPATHに存在する場合のみ削除処理が実行される | E-02 | ○ |
| C-07 | pathItems.Remove(dir)でリストからフォルダを削除する | E-02 | ○ |
| C-08 | Environment.SetEnvironmentVariableで環境変数を更新する | E-02 | ○ |
| C-09 | フォルダがPATHに存在しない場合はMsgErrorを表示する | E-02 | ○ |
| C-10 | TaskDialogで操作選択（Add/Remove/Editor）を提供する | E-01 | ○ |
| C-11 | 例外発生時はg.ShowException(ex)で表示する | E-01 | ○ |
| C-12 | 通知カテゴリは「情報通知」である | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] AppsForm.vb行1183のMsgInfo呼び出しを確認
- [ ] 環境変数操作のプラットフォーム分岐を確認（行1158-1159）
- [ ] 通知一覧.csvとの整合性を確認
