---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-デマクサ名不一致警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/CommandLineDemuxForm.vb` 行420-431（HelpToolStripMenuItem_Clickメソッド）
- E-02: `Source/Forms/CommandLineDemuxForm.vb` 行429-430（MsgWarn呼び出し）
- E-03: `Source/Forms/CommandLineDemuxForm.vb` 行421-427（パッケージ検索ループ）
- E-04: `Docs/code-to-docs/通知一覧/通知一覧.csv` 行85（通知定義）
- E-05: `Docs/code-to-docs/画面設計書/21-コマンドラインデマックス.md` 行108（メッセージ仕様）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「The demuxer name does not match」を含む | E-02, E-04, E-05 | ○ |
| C-02 | CommandLineDemuxFormのHelpToolStripMenuItem_Clickメソッドがエントリーポイントである | E-01 | ○ |
| C-03 | MsgWarn関数で警告通知として表示される | E-02 | ○ |
| C-04 | Package.Items.Valuesをループしてパッケージ名を検索する | E-03 | ○ |
| C-05 | tbName.Textでユーザー入力のデマクサ名を取得する | E-02, E-03 | ○ |
| C-06 | 一致するパッケージがあればpack.ShowHelp()を呼び出す | E-03 | ○ |
| C-07 | PluginPackageはアプリ一覧から除外される | E-02 | ○ |
| C-08 | アプリ名一覧はソートされてカンマ区切りで表示される | E-02 | ○ |
| C-09 | 通知カテゴリは「警告通知」である | E-04 | ○ |
| C-10 | CommandLineDemuxForm使用時に発生する | E-04 | ○ |
| C-11 | Helpメニュー選択時にトリガーされる | E-01 | ○ |
| C-12 | デマクサの動作自体には影響しない情報提供目的の警告である | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] CommandLineDemuxForm.vb行429-430のMsgWarn呼び出しを確認
- [ ] Package.Items.ValuesからPluginPackageが除外されていることを確認
- [ ] 通知一覧.csvおよび画面設計書との整合性を確認
