---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-設定リセット確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/GlobalClass.vb` 行84-115（LoadSettingsメソッド）
- E-02: `Source/General/GlobalClass.vb` 行103-109（Resetケース処理）
- E-03: `Source/General/GlobalClass.vb` 行104（MsgQuestion呼び出し）
- E-04: `Docs/code-to-docs/通知一覧/通知一覧.csv` 行86（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Are you sure you want to reset your settings?」を含む | E-03, E-04 | ○ |
| C-02 | GlobalClassのLoadSettingsメソッドがエントリーポイントである | E-01 | ○ |
| C-03 | MsgQuestion関数で質問ダイアログとして表示される | E-03 | ○ |
| C-04 | 設定読み込みエラー時のCatch節で処理される | E-01 | ○ |
| C-05 | TaskDialogでRetry/Reset/Exitの3つの選択肢を提供する | E-01 | ○ |
| C-06 | Reset選択後に確認ダイアログが表示される | E-02 | ○ |
| C-07 | OK選択時にNew ApplicationSettingsが作成される | E-02 | ○ |
| C-08 | OK選択時にs.Init()が呼び出される | E-02 | ○ |
| C-09 | Cancel選択時にLoadSettings()が再帰呼び出しされる | E-02 | ○ |
| C-10 | 通知カテゴリは「確認ダイアログ」である | E-04 | ○ |
| C-11 | GlobalClass使用時に発生する | E-04 | ○ |
| C-12 | Mutexを使用した排他制御で設定ファイルをデシリアライズする | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vb行104のMsgQuestion呼び出しを確認
- [ ] Reset処理後の設定初期化フロー（行105-106）を確認
- [ ] Cancel時の再試行処理（行108）を確認
- [ ] 通知一覧.csvとの整合性を確認
