---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-ファイル削除確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/ToolUpdate.vb` 行127-159（DeleteOldFilesメソッド）
- E-02: `Source/General/ToolUpdate.vb` 行134-135（MsgQuestion呼び出し）
- E-03: `Source/General/ToolUpdate.vb` 行137-151（ファイル・フォルダ削除処理）
- E-04: `Source/General/ToolUpdate.vb` 行142, 150（RecycleOption.SendToRecycleBin使用）
- E-05: `Docs/code-to-docs/通知一覧/通知一覧.csv` 行87（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Delete current files?」である | E-02, E-05 | ○ |
| C-02 | ToolUpdateのDeleteOldFilesメソッドがエントリーポイントである | E-01 | ○ |
| C-03 | MsgQuestion関数で質問ダイアログとして表示される | E-02 | ○ |
| C-04 | TargetDirとファイル一覧がメッセージに含まれる | E-02 | ○ |
| C-05 | Package.Keepに含まれるファイルは除外される | E-01, E-03 | ○ |
| C-06 | OK選択時にファイルがゴミ箱に移動される | E-03, E-04 | ○ |
| C-07 | RecycleOption.SendToRecycleBinが使用される | E-04 | ○ |
| C-08 | Cancel選択時に「Update was canceled.」が表示される | E-01 | ○ |
| C-09 | ファイル削除後にフォルダ削除が実行される | E-03 | ○ |
| C-10 | 削除処理後にCopyFiles()が呼び出される | E-01 | ○ |
| C-11 | 通知カテゴリは「確認ダイアログ」である | E-05 | ○ |
| C-12 | ToolUpdate使用時に発生する | E-05 | ○ |
| C-13 | Directory.GetFileSystemEntriesで対象ファイルを取得する | E-01 | ○ |
| C-14 | Where句でPackage.Keep対象を除外する | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ToolUpdate.vb行134-135のMsgQuestion呼び出しを確認
- [ ] ゴミ箱への移動処理（RecycleOption.SendToRecycleBin）を確認
- [ ] Package.Keep除外処理を確認
- [ ] 通知一覧.csvとの整合性を確認
