---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-ファイルコピー確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/ToolUpdate.vb` 行161-186（CopyFilesメソッド）
- E-02: `Source/General/ToolUpdate.vb` 行167-169（MsgQuestion呼び出し）
- E-03: `Source/General/ToolUpdate.vb` 行171-177（ファイル・フォルダコピー処理）
- E-04: `Source/General/ToolUpdate.vb` 行184（ExtractDir削除処理）
- E-05: `Docs/code-to-docs/通知一覧/通知一覧.csv` 行88（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Copy new files?」である | E-02, E-05 | ○ |
| C-02 | ToolUpdateのCopyFilesメソッドがエントリーポイントである | E-01 | ○ |
| C-03 | MsgQuestion関数で質問ダイアログとして表示される | E-02 | ○ |
| C-04 | ExtractDir、TargetDir、ファイル一覧がメッセージに含まれる | E-02 | ○ |
| C-05 | OK選択時にファイルがコピーされる | E-03 | ○ |
| C-06 | OK選択時にフォルダがコピーされる | E-03 | ○ |
| C-07 | コピー完了後にExtractDirがゴミ箱に移動される | E-04 | ○ |
| C-08 | Cancel選択時に「Update was canceled.」が表示される | E-01 | ○ |
| C-09 | コピー処理後にEditVersion()が呼び出される | E-01 | ○ |
| C-10 | 通知カテゴリは「確認ダイアログ」である | E-05 | ○ |
| C-11 | ToolUpdate使用時に発生する | E-05 | ○ |
| C-12 | Directory.GetFileSystemEntriesで対象ファイルを取得する | E-01 | ○ |
| C-13 | FileHelp.CopyとFolderHelp.Copyが使用される | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ToolUpdate.vb行167-169のMsgQuestion呼び出しを確認
- [ ] ファイル・フォルダコピー処理（行171-177）を確認
- [ ] ExtractDir削除処理（行184）を確認
- [ ] 通知一覧.csvとの整合性を確認
