---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-入力形式非対応警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AudioForm.vb` 行1654-1670（Executeメソッド）
- E-02: `Source/Forms/AudioForm.vb` 行1656-1657（入力形式チェックとMsgWarn呼び出し）
- E-03: `Source/Forms/AudioForm.vb` 行1655（ファイル存在チェック）
- E-04: `Source/Forms/AudioForm.vb` 行1667-1668（ソースファイル不在警告）
- E-05: `Docs/code-to-docs/通知一覧/通知一覧.csv` 行91（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「The input format isn't supported by the current encoder」を含む | E-02, E-05 | ○ |
| C-02 | 「convert to WAV or FLAC first or enable piping in the options」という案内が含まれる | E-02 | ○ |
| C-03 | AudioFormのExecuteメソッドがエントリーポイントである | E-01 | ○ |
| C-04 | MsgWarn関数で警告通知として表示される | E-02 | ○ |
| C-05 | TempProfile.IsInputSupportedがFalseの場合にチェックされる | E-02 | ○ |
| C-06 | TempProfile.DecodingModeがPipeでない場合にチェックされる | E-02 | ○ |
| C-07 | 両方の条件がAndAlsoで結合されている | E-02 | ○ |
| C-08 | TempProfile.Fileが空の場合は別の警告が表示される | E-03, E-04 | ○ |
| C-09 | ソースファイル不在時は「Source file is missing!」が表示される | E-04 | ○ |
| C-10 | 条件を満たす場合はエンコード処理が実行される | E-01 | ○ |
| C-11 | 通知カテゴリは「警告通知」である | E-05 | ○ |
| C-12 | AudioForm使用時に発生する | E-05 | ○ |
| C-13 | BR定数で改行が挿入されている | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] AudioForm.vb行1656-1657の条件チェックとMsgWarn呼び出しを確認
- [ ] IsInputSupportedとDecodingModeの条件を確認
- [ ] 通知一覧.csvとの整合性を確認
