---
generated_at: 2026-01-21 19:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：91-ソースファイル不在警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AudioForm.vb` 行1654-1670（Executeメソッド）
- E-02: `Source/General/General.vb` 行1245-1255（MsgWarn関数）
- E-03: `Source/General/General.vb` 行1274-1282（Msg関数）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行92

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージが「Source file is missing!」である | E-01 (行1668) | ○ |
| C-02 | MsgWarn関数で警告表示される | E-01 (行1668), E-02 | ○ |
| C-03 | TempProfile.Fileが空の場合に表示される | E-01 (行1655, 1667) | ○ |
| C-04 | AudioFormのExecuteメソッドで発生する | E-01 (行1654) | ○ |
| C-05 | TaskIcon.Warningアイコンが使用される | E-02 (行1250) | ○ |
| C-06 | TaskButton.OKボタンが使用される | E-02 (行1250) | ○ |
| C-07 | 同期的にダイアログ表示される | E-03 (行1280) | ○ |
| C-08 | カテゴリが警告通知である | E-04 | ○ |
| C-09 | 入力形式非対応エラーと相互排他的 | E-01 (行1655-1668) | ○ |
| C-10 | ソースファイル設定後は表示されない | E-01 (行1655) | ○ |
| C-11 | AudioForm使用時に発生 | E-04 | ○ |
| C-12 | 処理が中断される | E-01 (行1667-1669) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] AudioForm.vbの行1668でMsgWarnが呼び出されていることを確認
- [ ] TempProfile.Fileの判定ロジックが正しいことを確認
