---
generated_at: 2026-01-21 19:17:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：93-サブフォルダ含有確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/SourceFilesForm.vb` 行230-261（bnAdd_Clickメソッド）
- E-02: `Source/General/General.vb` 行1261-1266（MsgQuestion関数）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行94

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージが「Include sub folders?」である | E-01 (行250) | ○ |
| C-02 | MsgQuestion関数で確認表示される | E-01 (行250), E-02 | ○ |
| C-03 | TaskButton.YesNoボタンが使用される | E-01 (行250) | ○ |
| C-04 | サブフォルダが存在する場合のみ表示される | E-01 (行249) | ○ |
| C-05 | SourceFilesFormのbnAdd_Clickで発生する | E-01 (行230) | ○ |
| C-06 | Yesの場合AllDirectoriesで検索される | E-01 (行251) | ○ |
| C-07 | Noの場合TopDirectoryOnlyで検索される | E-01 (行247) | ○ |
| C-08 | FileTypes.Videoの拡張子でフィルタされる | E-01 (行255) | ○ |
| C-09 | StringLogicalComparerでソートされる | E-01 (行255) | ○ |
| C-10 | FolderBrowserDialogでフォルダ選択する | E-01 (行244) | ○ |
| C-11 | Directory.GetDirectoriesでサブフォルダ取得 | E-01 (行246) | ○ |
| C-12 | SourceFilesForm使用時に発生 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] SourceFilesForm.vbの行250でMsgQuestionが呼び出されていることを確認
- [ ] SearchOptionの切り替えロジックが正しいことを確認
- [ ] ビデオファイルのフィルタリングとソートが適切に行われることを確認
