---
generated_at: 2026-01-21 19:21:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：97-ジョブ上書き確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行4105-4114（ジョブ追加処理）
- E-02: `Source/General/General.vb` 行1268-1272（MsgQuestion関数）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行98

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージが「An active job for this project already exists.」を含む | E-01 (行4111) | ○ |
| C-02 | 「If you continue, it will be overwritten.」が含まれる | E-01 (行4111) | ○ |
| C-03 | MsgQuestion関数で確認表示される | E-01 (行4111), E-02 | ○ |
| C-04 | jobs.Any()がTrueの場合に表示される | E-01 (行4110) | ○ |
| C-05 | MainFormのジョブ追加処理で発生する | E-01 | ○ |
| C-06 | JobManager.JobPathでジョブパスを取得する | E-01 (行4107) | ○ |
| C-07 | JobManager.GetJobs()でジョブ一覧を取得する | E-01 (行4108) | ○ |
| C-08 | ActiveプロパティとPathプロパティでフィルタリングする | E-01 (行4108) | ○ |
| C-09 | TaskButton.OkCancelボタンが使用される | E-01 (行4111) | ○ |
| C-10 | キャンセル時にExit Subで処理を中断する | E-01 (行4112) | ○ |
| C-11 | BeforeJobAddingイベントが先に発生する | E-01 (行4105) | ○ |
| C-12 | MainForm使用時に発生 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] MainForm.vbの行4111でMsgQuestionが呼び出されていることを確認
- [ ] ジョブフィルタリング条件（Active AndAlso Path）が正しいことを確認
- [ ] キャンセル時の処理中断が適切に実装されていることを確認
