---
generated_at: 2026-01-21 19:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **初回起動時の設定フロー**：根拠不足（実際の初回起動動作の検証が必要）
  2. **対応ブラウザ/動作環境の詳細**：根拠不足（README.mdの記載を参照したが詳細確認が必要）
  3. **サポート連絡先URL**：根拠不足（URLの有効性は外部確認が必要）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - プロジェクト概要、技術スタック
- E-02: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件定義
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応
- E-07: `docs/code-to-docs/画面設計書/1-MainForm.md` - メイン画面設計
- E-08: `docs/code-to-docs/画面設計書/2-PreviewForm.md` - プレビュー画面設計
- E-09: `docs/code-to-docs/画面設計書/3-ProcessingForm.md` - 処理画面設計
- E-10: `docs/code-to-docs/画面設計書/4-JobsForm.md` - ジョブ管理画面設計
- E-11: `docs/code-to-docs/画面設計書/5-CropForm.md` - クロップ画面設計
- E-12: `docs/code-to-docs/画面設計書/6-AudioForm.md` - オーディオ画面設計
- E-13: `docs/code-to-docs/画面設計書/7-AppsForm.md` - アプリケーション設定画面設計

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StaxRipはWindows向けの高機能なビデオエンコーディングGUIアプリケーション | E-01 | ○ |
| C-02 | x265、x264、NVEnc、SVT-AV1など多数のエンコーダーをサポート | E-01, E-02, E-05 | ○ |
| C-03 | AviSynth+およびVapourSynthによるフィルター処理をサポート | E-01, E-02, E-05 | ○ |
| C-04 | 主要業務はソースファイル管理、映像処理、エンコード、音声処理、マックス処理、ジョブ管理 | E-02 | ○ |
| C-05 | Windows 8以降で動作（Windows 7は一部機能制限あり） | E-01 | ○ |
| C-06 | .NET Framework 4.8が必要 | E-01 | ○ |
| C-07 | メイン画面（MainForm）はソース、ターゲット、フィルター、リサイズ、エンコーダー、オーディオ、アシスタントで構成 | E-07 | ○ |
| C-08 | ドラッグ&ドロップでソースファイルを指定可能 | E-07 | ○ |
| C-09 | 対応ソースファイル形式はMKV、MP4、M2TS、AVI、VOB等 | E-02, E-05 | ○ |
| C-10 | MediaInfoによりメディア情報を自動取得 | E-02 | ○ |
| C-11 | 複数ソースファイルの結合が可能（SourceFilesForm） | E-02, E-03 | ○ |
| C-12 | クロップ画面でマウス/キーボード/マウスホイールによるクロップ操作が可能 | E-11 | ○ |
| C-13 | 自動クロップ機能（Aキー）で黒帯を自動検出 | E-02, E-11 | ○ |
| C-14 | スマートクロップ機能（Sキー）でアスペクト比維持クロップが可能 | E-02, E-11 | ○ |
| C-15 | フィルターはAviSynth/VapourSynthで追加・編集・削除可能 | E-02, E-07 | ○ |
| C-16 | リサイズ設定で目標解像度を指定可能 | E-02, E-07 | ○ |
| C-17 | エンコーダーとしてx265（デフォルト）、x264、NVEnc、QSVEnc、VCEEnc、SVT-AV1が使用可能 | E-02, E-05 | ○ |
| C-18 | ビットレートまたはターゲットサイズからエンコード設定が可能 | E-02, E-07 | ○ |
| C-19 | 音声コーデックとしてAAC、AC3、FLAC、Opusが使用可能 | E-02, E-05, E-12 | ○ |
| C-20 | 音声正規化機能（Normalize）が利用可能 | E-02, E-12 | ○ |
| C-21 | 出力コンテナとしてMKV、MP4、WebMが選択可能 | E-02, E-05 | ○ |
| C-22 | MuxerFormで字幕追加が可能 | E-06 | ○ |
| C-23 | アシスタント機能で次のステップをガイド | E-02, E-07 | ○ |
| C-24 | Nextボタンでエンコードを開始 | E-07 | ○ |
| C-25 | ProcessingFormでエンコード進捗を表示 | E-09 | ○ |
| C-26 | Abortボタン（ESC）で処理を中断可能 | E-09 | ○ |
| C-27 | F6キーでジョブ管理画面を表示 | E-09, E-10 | ○ |
| C-28 | F8キーでログを表示 | E-09 | ○ |
| C-29 | 処理完了後のシャットダウン設定が可能 | E-09 | ○ |
| C-30 | ジョブ管理画面でジョブのキュー管理が可能 | E-02, E-10 | ○ |
| C-31 | ジョブの順序変更（Up/Downボタン）が可能 | E-10 | ○ |
| C-32 | プレビュー画面で左右矢印キーで1フレーム移動 | E-08 | ○ |
| C-33 | プレビュー画面でPageUp/PageDownで100フレーム移動 | E-08 | ○ |
| C-34 | カット範囲の設定（Home/Endキー）が可能 | E-08 | ○ |
| C-35 | Deleteキーでカット範囲を削除可能 | E-08 | ○ |
| C-36 | Ctrl+Sでビットマップ保存、Ctrl+PでPNG保存 | E-08 | ○ |
| C-37 | AppsFormで外部ツールの管理が可能 | E-13 | ○ |
| C-38 | ツールのステータス（OK/Missing/Wrong Version）を確認可能 | E-13 | ○ |
| C-39 | Installボタンでツールをダウンロード可能 | E-13 | ○ |
| C-40 | プロジェクトを.srip形式で保存・読み込み可能 | E-02 | ○ |
| C-41 | テンプレート機能でエンコード設定を保存・適用可能 | E-02, E-05 | ○ |
| C-42 | GitHub、Discord、VideoHelp Forum、Doom9 Forumでサポートを受けられる | E-01 | ○ |
| C-43 | 初回起動時に設定保存先選択ダイアログが表示される | **根拠なし** | △ |
| C-44 | Windows 10/11が推奨動作環境 | **根拠なし** | △ |
| C-45 | サポートURL（Discord等）が有効である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **初回起動時のフロー** - ソースコードの実際の初回起動処理を確認する必要がある
  - 候補：Source/Forms/MainForm.vb / Source/Settings.vb / Source/GlobalClass.vb
- **動作環境の詳細** - README.mdの記載を確認したが、推奨環境としてWindows 10/11の明示的な記載がない
  - 候補：README.md / インストールガイド / 公式ドキュメント
- **外部URLの有効性** - GitHub、Discord等のURLは実在するが、有効性は外部確認が必要
  - 候補：各URL先への実際のアクセス確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、主要機能説明、画面構成（ソースコード・設計書と整合）
- **0: 低リスク** - エンコードワークフローの説明（業務要件一覧・機能一覧と整合）
- **0: 低リスク** - 各画面の操作手順（画面設計書と整合）
- **1: 中リスク** - 初回起動時の動作説明（詳細な検証が必要）
- **1: 中リスク** - トラブルシューティングの一部（一般的な対処法であり、StaxRip固有の検証が不十分な可能性）
- **0: 低リスク** - キーボードショートカット（画面設計書に明記）

## 6) レビュアーチェックリスト（最小）
- [ ] システム概要（1章）がREADME.mdと整合しているか
- [ ] ワークフローの各STEPが業務要件一覧の要件をカバーしているか
- [ ] メイン画面の説明が画面設計書（1-MainForm.md）と整合しているか
- [ ] プレビュー画面のキーボードショートカットが画面設計書（2-PreviewForm.md）と整合しているか
- [ ] クロップ画面の操作説明が画面設計書（5-CropForm.md）と整合しているか
- [ ] 処理画面の機能説明が画面設計書（3-ProcessingForm.md）と整合しているか
- [ ] ジョブ管理画面の説明が画面設計書（4-JobsForm.md）と整合しているか
- [ ] 初回起動時のフローを実際のアプリケーションで検証（△項目）
- [ ] サポートURLの有効性を確認（△項目）
- [ ] トラブルシューティングの対処法が実際に有効か検証
