# StaxRip 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [起動・終了手順](#2-起動終了手順)
3. [メイン画面（MainForm）](#3-メイン画面mainform)

**【ワークフローに沿った機能】**
4. [【STEP1】ソースファイルの準備（読み込み・解析）](#4-step1ソースファイルの準備読み込み解析)
5. [【STEP2-3】映像処理設定（クロップ・フィルター・リサイズ）](#5-step2-3映像処理設定クロップフィルターリサイズ)
6. [【STEP3-4】エンコード設定（エンコーダー・音声・出力形式）](#6-step3-4エンコード設定エンコーダー音声出力形式)
7. [【STEP4-5】エンコード実行・ジョブ管理](#7-step4-5エンコード実行ジョブ管理)

**【サポート機能】**
8. [プレビュー機能](#8-プレビュー機能)
9. [外部ツール管理](#9-外部ツール管理)
10. [プロファイル・テンプレート管理](#10-プロファイルテンプレート管理)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 StaxRipとは

StaxRipは、Windows向けの高機能なビデオ/オーディオエンコーディングGUIアプリケーションです。x265、x264、NVEnc、SVT-AV1など多数のエンコーダーと、AviSynth+およびVapourSynthによるフィルター処理をサポートし、動画変換に必要なすべての機能を一つの画面で統合的に操作できます。

StaxRipは「ワンクリックエンコーダー」ではなく、ユーザーが目的を理解し適切に設定することで、プロフェッショナルな品質の動画エンコードを実現できる強力なツールです。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ソースファイル管理** | 動画ファイルの読み込み、メディア情報取得、複数ファイル結合 |
| **映像処理** | クロップ（黒帯除去）、リサイズ、フィルター適用、カット編集 |
| **映像エンコード** | x264/x265/NVEnc/AV1等でのビデオエンコード、ビットレート計算 |
| **音声処理** | 音声抽出、エンコード、正規化、チャンネル変換 |
| **マックス処理** | MKV/MP4/WebM形式への多重化、チャプター・字幕埋め込み |
| **ジョブ管理** | 複数エンコードジョブのキュー管理、バッチ処理 |

### 1.3 ワークフロー概要

本システムにおける動画エンコード業務は、以下の流れで進行します：

```
+-----------------------------------------------------------------+
|                     エンコードワークフロー                        |
+-----------------------------------------------------------------+
|                                                                 |
|  【STEP 1】ソースファイルを読み込み、メディア情報を解析          |
|      ↓                                                          |
|  【STEP 2】クロップ、フィルター、リサイズの映像処理設定          |
|      ↓                                                          |
|  【STEP 3】エンコーダー、音声、出力形式を設定                    |
|      ↓                                                          |
|  【STEP 4】エンコード処理を実行（またはジョブキューに追加）      |
|      ↓                                                          |
|  【STEP 5】処理完了、出力ファイルの確認                          |
|                                                                 |
+-----------------------------------------------------------------+
```

**作業者別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **エンドユーザー** | ソースファイル指定、エンコード設定、エンコード実行、出力確認 |
| **上級ユーザー** | カスタムフィルター設定、スクリプト編集、バッチ処理、自動化設定 |

### 1.4 主な機能

| 機能 | 説明 | ワークフローでの位置 |
|------|------|------------------|
| ソースファイル読み込み | 動画ファイルを指定してプロジェクトに設定 | STEP 1 |
| クロップ/リサイズ | 映像の黒帯除去、解像度変更 | STEP 2 |
| フィルター適用 | AviSynth/VapourSynthフィルターによる映像処理 | STEP 2 |
| エンコーダー設定 | x264/x265/NVEnc等のパラメータ設定 | STEP 3 |
| 音声設定 | 音声エンコード、正規化、チャンネル変換 | STEP 3 |
| プレビュー | フィルター適用後の映像確認 | 随時利用 |
| ジョブ管理 | 複数エンコードの一括処理 | STEP 4-5 |
| プロファイル管理 | 設定テンプレートの保存・適用 | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー | 基本的なエンコード設定と実行を行うユーザー |
| 上級ユーザー | カスタムスクリプト、バッチ処理、自動化を行うユーザー |

### 1.6 動作環境

**対応OS：**
- Windows 8 以降（Windows 7は一部機能制限あり）
- Windows 10/11 推奨

**必要条件：**
- Microsoft Visual C++ Redistributable Runtimes
- .NET Framework 4.8

---

## 2. 起動・終了手順

### 2.1 起動方法

1. StaxRipのインストールフォルダを開きます
2. 「StaxRip.exe」をダブルクリックして起動します
3. メイン画面（MainForm）が表示されます

**初回起動時：**

1. 設定保存先の選択ダイアログが表示されます
2. 推奨: 起動フォルダ内のサブフォルダを選択します
3. 必要な外部ツールの確認・ダウンロードが行われます

### 2.2 終了方法

1. 画面右上の「X」ボタンをクリックします
2. または、メニューから「Project」→「Exit」を選択します
3. 未保存の変更がある場合は保存確認ダイアログが表示されます

### 2.3 エンコード処理中の終了

**注意：** エンコード処理中に終了する場合は、必ず以下の手順を行ってください。

1. 処理画面（ProcessingForm）で「Abort」ボタンをクリックします
2. 確認ダイアログで「はい」を選択します
3. 処理が中断されてからアプリケーションを終了します

---

## 3. メイン画面（MainForm）

### 3.1 画面構成

メイン画面は、動画エンコードに必要なすべての設定を一画面で管理できる中心的なインターフェースです。

```
+------------------------------------------------------------------+
| メニューバー（Project / View / Size / Tools / Apps / Help）        |
+------------------------------------------------------------------+
| +----------------------------+ +------------------------------+  |
| | ソース設定                  | | ターゲット設定                |  |
| | - ソースファイルパス        | | - 出力ファイルパス            |  |
| | - ソース情報表示            | | - ターゲットサイズ/ビットレート|  |
| +----------------------------+ +------------------------------+  |
| +----------------+ +----------------+ +------------------------+ |
| | フィルター     | | リサイズ       | | エンコーダー           | |
| | (AviSynth/VS)  | | (解像度設定)   | | (x265/x264/NVEnc等)   | |
| +----------------+ +----------------+ +------------------------+ |
| +------------------------------------------------------------------+
| | オーディオ設定                                                    |
| +------------------------------------------------------------------+
| | アシスタント                                                      |
| | - 次のステップへのガイダンス                                       |
| | - [Next]ボタン                                                    |
| +------------------------------------------------------------------+
```

### 3.2 主要エリアの説明

| エリア | 説明 |
|--------|------|
| **ソース設定** | 変換元の動画ファイルを指定。ファイル情報（解像度、フレームレート等）が自動表示されます |
| **ターゲット設定** | 出力ファイルのパス、目標サイズまたはビットレートを設定 |
| **フィルター** | AviSynth+またはVapourSynthのフィルターチェーンを構築 |
| **リサイズ** | 出力動画の解像度を設定。アスペクト比の維持も可能 |
| **エンコーダー** | 使用するエンコーダー（x265/x264/NVEnc等）とパラメータを設定 |
| **オーディオ** | 音声トラックのエンコード設定 |
| **アシスタント** | 現在の設定状態に応じて次に行うべき操作をガイド |

### 3.3 基本操作

**ドラッグ&ドロップ：** 動画ファイルをメイン画面にドラッグ&ドロップすることで、ソースファイルを指定できます。

**クリック操作：** 各設定エリアのリンク（青字テキスト）をクリックすると、詳細設定画面が開きます。

---

## 4. 【STEP1】ソースファイルの準備（読み込み・解析）

> **ワークフローでの位置**: エンコード作業の最初のステップです。変換元の動画ファイルを指定し、メディア情報を確認します。

### 4.1 ソースファイルを読み込む

1. メイン画面の「Source」欄の「...」ボタンをクリックします
2. ファイル選択ダイアログでソースファイルを選択します
3. 「開く」をクリックします

**対応形式：** MKV、MP4、M2TS、AVI、VOB等の主要な動画形式

**代替方法：** ソースファイルをメイン画面にドラッグ&ドロップしても読み込めます。

### 4.2 メディア情報を確認する

ソースファイル読み込み後、以下の情報が自動的に表示されます：

| 項目 | 説明 |
|------|------|
| 解像度 | ソース動画の幅×高さ（例: 1920x1080） |
| フレームレート | 1秒あたりのフレーム数（例: 23.976fps） |
| 長さ | 動画の総再生時間 |
| ビットレート | ソースのビットレート |
| コーデック | ソースの映像コーデック（例: H.264/AVC） |

### 4.3 複数ファイルを結合する

複数の動画ファイルを1つとして処理する場合：

1. メニューから「Project」→「Source Files」を選択します
2. SourceFilesFormで「Add」ボタンをクリックしてファイルを追加します
3. ファイルの順序をドラッグ&ドロップで調整します
4. 「OK」をクリックして確定します

**注意：** 結合するファイルは同じフレームレートである必要があります。

### 4.4 Blu-ray/DVDを読み込む

1. Blu-ray ISOファイルまたはDVD VOBファイルを選択します
2. 必要に応じてeac3toFormでストリーム選択を行います

---

## 5. 【STEP2-3】映像処理設定（クロップ・フィルター・リサイズ）

> **ワークフローでの位置**: ソースファイル読み込み後、映像の前処理を行うステップです。

### 5.1 クロップ設定（黒帯の除去）

#### 5.1.1 クロップ画面を開く

1. メイン画面の「Crop」リンクをクリックします
2. CropFormが開き、現在のフレームが表示されます

#### 5.1.2 自動クロップ

1. クロップ画面で「A」キーを押すか、メニューから「Auto Crop」を選択します
2. 黒帯が自動検出され、クロップ値が設定されます

#### 5.1.3 手動クロップ

- **マウス操作：** 境界線をドラッグしてクロップ範囲を調整します
- **キーボード操作：**
  - 「+」/「-」キー: アクティブな辺を2ピクセル増減
  - 「Shift」+「+」/「-」: 8ピクセル増減
- **マウスホイール：** アクティブな辺のクロップ値を調整

#### 5.1.4 スマートクロップ

1. 「S」キーを押すか、メニューから「Smart Crop」を選択します
2. アスペクト比を維持しながらクロップが調整されます

### 5.2 フィルター設定

#### 5.2.1 フィルターを追加する

1. メイン画面の「Filters」エリアを右クリックします
2. コンテキストメニューから追加したいフィルターを選択します
3. フィルターがリストに追加されます

**主なフィルター：**
- **Resize**: 解像度変更
- **Denoise**: ノイズ除去
- **Sharpen**: シャープネス調整
- **Deinterlace**: インターレース解除

#### 5.2.2 フィルター順序を変更する

1. フィルターリストでフィルターをドラッグします
2. 目的の位置にドロップします

#### 5.2.3 フィルターを無効化/削除する

- **無効化：** フィルターをダブルクリックして有効/無効を切り替えます
- **削除：** フィルターを選択して「Delete」キーを押します

### 5.3 リサイズ設定

1. メイン画面の「Target Width」と「Target Height」に目標解像度を入力します
2. または「Resize」スライダーで割合を指定します

**アスペクト比の維持：** 幅または高さの一方を入力すると、アスペクト比に基づいて他方が自動計算されます。

**MOD値：** 解像度は通常MOD2（2の倍数）に自動補正されます。

---

## 6. 【STEP3-4】エンコード設定（エンコーダー・音声・出力形式）

> **ワークフローでの位置**: 映像処理設定後、エンコードパラメータを設定するステップです。

### 6.1 エンコーダー設定

#### 6.1.1 エンコーダーを選択する

1. メイン画面の「Encoder」エリアをクリックします
2. 表示されるメニューからエンコーダーを選択します

**主なエンコーダー：**
| エンコーダー | 説明 |
|-------------|------|
| x265 | HEVCコーデック（デフォルト） |
| x264 | H.264/AVCコーデック |
| NVEnc | NVIDIA GPUハードウェアエンコード |
| QSVEnc | Intel QSVハードウェアエンコード |
| VCEEnc | AMD VCEハードウェアエンコード |
| SVT-AV1 | AV1コーデック |

#### 6.1.2 エンコーダー詳細設定

1. エンコーダー名のリンクをクリックします
2. CommandLineFormが開き、詳細パラメータを設定できます

### 6.2 ビットレート設定

#### 6.2.1 ビットレートを指定する

1. メイン画面の「Bitrate」欄に目標ビットレート（kbps）を入力します

#### 6.2.2 ターゲットサイズから計算する

1. 「Target Size」欄に目標ファイルサイズ（MB）を入力します
2. ビットレートが自動計算されます

### 6.3 音声設定

#### 6.3.1 音声設定画面を開く

1. メイン画面の「Audio」エリアで、編集したいトラックをクリックします
2. AudioFormが開きます

#### 6.3.2 音声コーデックを選択する

1. 「Codec」ドロップダウンから出力コーデックを選択します
   - AAC: 汎用的な圧縮形式
   - AC3: DVD/Blu-ray向け
   - FLAC: 可逆圧縮
   - Opus: 高効率圧縮

2. 「Bitrate」を設定します

#### 6.3.3 音声正規化

1. 「Normalize」チェックボックスをオンにします
2. 音量レベルが自動的に正規化されます

### 6.4 出力形式設定

#### 6.4.1 コンテナを選択する

1. メイン画面の「Muxer」リンクをクリックします
2. MuxerFormが開きます
3. 出力コンテナ形式を選択します
   - MKV: 最も汎用的、字幕・チャプター対応
   - MP4: 広い互換性
   - WebM: Web向け

#### 6.4.2 字幕を追加する

1. MuxerFormの「Subtitles」タブを開きます
2. 「Add」ボタンで字幕ファイルを追加します
3. 言語、デフォルト設定を行います

### 6.5 出力ファイルの指定

1. メイン画面の「Target」欄に出力ファイルパスを入力します
2. または「...」ボタンで保存先を選択します

---

## 7. 【STEP4-5】エンコード実行・ジョブ管理

> **ワークフローでの位置**: 設定完了後、エンコード処理を実行し、完了を確認するステップです。

### 7.1 エンコードを開始する

1. メイン画面下部のアシスタントエリアを確認します
2. 「Next」ボタンをクリックします
3. 処理画面（ProcessingForm）が表示され、エンコードが開始されます

### 7.2 処理中の操作

処理画面（ProcessingForm）では以下の操作が可能です：

| ボタン/操作 | 説明 |
|------------|------|
| 「Abort」(ESC) | 全ての処理を中断します |
| 「Jobs」(F6) | ジョブ管理画面を表示します |
| 「Log」(F8) | 詳細ログを表示します |
| 「When finished」 | 処理完了後の動作を設定（シャットダウン等） |

### 7.3 ジョブ管理

#### 7.3.1 ジョブ管理画面を開く

1. メニューから「View」→「Jobs」を選択します
2. または「F6」キーを押します
3. JobsFormが開きます

#### 7.3.2 ジョブをキューに追加する

1. メイン画面で設定を完了します
2. メニューから「Project」→「Add Job」を選択します
3. ジョブがキューに追加されます（エンコードは開始しません）

#### 7.3.3 複数ジョブを実行する

1. ジョブ管理画面で実行したいジョブにチェックを入れます
2. 「Start」ボタンをクリックします
3. チェックされたジョブが順次実行されます

#### 7.3.4 ジョブの順序を変更する

- 「Up」/「Down」ボタンで選択ジョブの順序を変更します
- Ctrl+Up/Ctrl+Downでも移動できます

### 7.4 処理完了後

1. エンコード完了後、処理画面が閉じます（設定による）
2. 出力ファイルを確認します
3. 必要に応じてプレビューで品質を確認します

---

## 8. プレビュー機能

### 8.1 プレビューを表示する

1. メニューから「View」→「Preview」を選択します
2. または該当するショートカットキーを押します
3. PreviewFormが開きます

### 8.2 フレームナビゲーション

| 操作 | 機能 |
|------|------|
| 左/右矢印キー | 1フレーム移動 |
| 上/下矢印キー | 10フレーム移動 |
| PageUp/PageDown | 100フレーム移動 |
| マウスホイール | フレーム移動 |
| G キー | 指定フレームにジャンプ |
| T キー | 指定時間にジャンプ |

### 8.3 カット編集

#### 8.3.1 カット範囲を設定する

1. 保持したい範囲の開始位置で「Home」キーまたは「start」ボタンをクリック
2. 終了位置で「End」キーまたは「end」ボタンをクリック
3. トラックバーに範囲が緑色で表示されます

#### 8.3.2 複数範囲を設定する

1. 同様の手順で複数の範囲を設定できます
2. 設定されていない部分がエンコード時にカットされます

#### 8.3.3 範囲を削除する

1. 削除したい範囲内にカーソルを移動します
2. 「Delete」キーまたは「del」ボタンをクリックします

### 8.4 画像を保存する

- Ctrl+S: BMP形式で保存
- Ctrl+P: PNG形式で保存

---

## 9. 外部ツール管理

### 9.1 外部ツール設定画面を開く

1. メニューから「Tools」→「Settings」を選択します
2. AppsFormが開きます

### 9.2 ツールの状態を確認する

左側のツリービューでツールを選択すると、右側に詳細情報が表示されます：

| 項目 | 説明 |
|------|------|
| Status | OK（正常）/ Missing（未インストール）/ Wrong Version（バージョン不一致） |
| Location | ツールのパス |
| Version | インストールされているバージョン |

### 9.3 ツールをダウンロードする

1. ツールを選択します
2. ステータスが「Missing」の場合、「Install」ボタンが表示されます
3. 「Install」ボタンをクリックしてダウンロードします

### 9.4 カスタムパスを設定する

1. ツールを選択します
2. メニューから「Tools」→「Edit Path...」を選択します
3. カスタムパスを入力します

---

## 10. プロファイル・テンプレート管理

### 10.1 プロファイルを保存する

1. 現在の設定を完了します
2. メニューから「Project」→「Save Project」を選択します
3. ファイル名を入力して保存します（.srip形式）

### 10.2 プロファイルを読み込む

1. メニューから「Project」→「Open Project」を選択します
2. 保存済みの.sripファイルを選択します
3. 設定が復元されます

### 10.3 テンプレートを使用する

1. メニューから「Project」→「Templates」を選択します
2. 使用したいテンプレートを選択します
3. 設定が適用されます

---

## 11. 日常業務の流れ

本セクションでは、ワークフローに沿った日常業務の流れを説明します。

```
ワークフロー概要（再掲）
---------------------------------------------------------------------
【STEP 1】ソースファイルを読み込み、メディア情報を解析 → 4章参照
    ↓
【STEP 2】クロップ、フィルター、リサイズの映像処理設定 → 5章参照
    ↓
【STEP 3】エンコーダー、音声、出力形式を設定 → 6章参照
    ↓
【STEP 4】エンコード処理を実行（またはジョブキューに追加）→ 7章参照
    ↓
【STEP 5】処理完了、出力ファイルの確認 → 7章参照
---------------------------------------------------------------------
```

### 11.1 【基本操作】STEP1: ソースファイルの読み込み

**業務シーン：** 新しい動画ファイルをエンコードする場合

**操作手順：**
1. StaxRipを起動します
2. ソースファイルをメイン画面にドラッグ&ドロップします
3. メディア情報が表示されることを確認します

**確認ポイント：**
- 解像度、フレームレートが正しく認識されているか
- 音声トラックが検出されているか

### 11.2 【映像処理】STEP2: クロップ・リサイズ設定

**業務シーン：** 黒帯のある動画をクロップし、適切な解像度に変換する場合

**操作手順：**
1. 「Crop」リンクをクリックしてクロップ画面を開きます
2. 「A」キーで自動クロップを実行します
3. 必要に応じて手動調整します
4. クロップ画面を閉じます
5. リサイズ設定で目標解像度を入力します

**確認ポイント：**
- 映像の重要な部分がカットされていないか
- アスペクト比が維持されているか

### 11.3 【エンコード設定】STEP3: エンコーダー・音声設定

**業務シーン：** x265でエンコードし、AAC音声で出力する場合

**操作手順：**
1. 「Encoder」エリアでx265を選択します
2. ビットレートまたはターゲットサイズを入力します
3. 「Audio」エリアで音声コーデックをAACに設定します
4. 出力ファイルパスを指定します

**確認ポイント：**
- ビットレートが目的に適しているか
- 音声設定が正しいか

### 11.4 【エンコード実行】STEP4-5: 処理実行と確認

**業務シーン：** 設定完了後、エンコードを実行する場合

**操作手順：**
1. アシスタントの指示を確認します
2. 「Next」ボタンをクリックしてエンコードを開始します
3. 処理画面で進捗を確認します
4. 完了後、出力ファイルを確認します

**確認ポイント：**
- エラーなく完了したか
- 出力ファイルのサイズ、品質が適切か

---

## 12. よくある質問と対処法

### 12.1 ソースファイルに関するQ&A

**Q: ソースファイルが読み込めません**

A: 以下を確認してください：
- ファイル形式が対応しているか（MKV、MP4、M2TS、AVI等）
- ファイルが破損していないか
- 必要なデコーダーがインストールされているか

**Q: 音声トラックが認識されません**

A: 以下を確認してください：
- 外部ツール（ffmpeg等）が正しくインストールされているか
- Tools→Settingsでツールのステータスを確認

### 12.2 エンコードに関するQ&A

**Q: エンコードが非常に遅いです**

A: 以下を試してください：
- ハードウェアエンコーダー（NVEnc/QSVEnc/VCEEnc）を使用する
- プリセットを「fast」や「medium」に変更する
- 不要なフィルターを無効にする

**Q: 出力ファイルのサイズが予想より大きいです**

A: 以下を確認してください：
- ビットレート設定が適切か
- ターゲットサイズを指定している場合、音声ビットレートも考慮されているか

### 12.3 品質に関するQ&A

**Q: 出力映像の品質が悪いです**

A: 以下を試してください：
- ビットレートを上げる
- CRF/CQ値を下げる（品質優先）
- 適切なプリセット（slower等）を選択する

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| ファイルが見つかりません | ソースファイルパスが無効 | ファイルパスを確認し、再指定してください |
| 出力先にアクセスできません | 出力フォルダへの書き込み権限がない | 出力先を変更するか、権限を確認してください |
| Script Error | AviSynth/VapourSynthスクリプトエラー | フィルター設定を確認し、エラー原因を修正してください |
| 無効なビットレート値です | ビットレートが0または負の値 | 正の整数値を入力してください |
| エンコーダーが見つかりません | 外部エンコーダーが未インストール | Tools→Settingsでインストールしてください |

### 13.2 よくあるトラブルと解決方法

**トラブル：処理が途中で停止する**

解決方法：
1. ログを確認してエラー原因を特定します（F8キー）
2. 一時ファイルが保存されるドライブの空き容量を確認します
3. メモリ不足の場合は、他のアプリケーションを終了します

**トラブル：プレビューが表示されない**

解決方法：
1. AviSynth+またはVapourSynthが正しくインストールされているか確認します
2. Tools→Settingsでステータスを確認します
3. フィルタースクリプトにエラーがないか確認します

**トラブル：音声が出力されない**

解決方法：
1. 音声トラック設定を確認します
2. 音声エンコーダーがインストールされているか確認します
3. 音声ファイルのdemux処理が正常に完了しているか確認します

### 13.3 サポートへの連絡方法

問題が解決しない場合は、以下のコミュニティでサポートを受けられます：

- **GitHub Wiki**: https://github.com/staxrip/staxrip/wiki
- **Discord**: https://discord.gg/uz8pVR79Bd
- **VideoHelp Forum**: https://forum.videohelp.com/threads/369913-StaxRip-support-thread
- **Doom9 Forum**: https://forum.doom9.org/showthread.php?t=172068

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-21 | 初版作成 |

---

*本マニュアルは、StaxRipのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
