---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **NFT-021 大容量ファイル処理**：具体的なメモリ制限値の明示的定義なし
  2. **NFT-027 アップデート確認**：更新確認のSLA定義なし
  3. **NFT-002 出力ハイライト処理時間**：具体的な性能基準値の定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/ProcController.vb` - プロセス制御、進捗更新、UI同期の実装
- E-02: `Source/General/JobManager.vb` - ジョブ管理、ディスク容量チェック、リトライ処理
- E-03: `Source/General/ApplicationSettings.vb` - アプリケーション設定、各種閾値定義
- E-04: `Source/General/General.vb` - ユーティリティクラス、電源管理、CUDA/Vulkan検出
- E-05: `Source/General/GlobalClass.vb` - グローバル状態管理、管理者権限確認
- E-06: `Source/General/Project.vb` - プロジェクト設定、ファイルパス検証
- E-07: `Source/Forms/ProcessingForm.vb` - 処理フォーム、システムトレイ、テーマ適用
- E-08: `README.md` - OS互換性情報、依存関係
- E-09: `Source/General/Misc.vb` - 計算ユーティリティ、サイズ計算

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: 進捗更新が200ms間隔で行われる | E-01 (ProcController.vb:367) | ○ |
| C-02 | NFT-002: 出力ハイライト処理時間が計測される | E-01 (ProcController.vb:222) | ○ |
| C-03 | NFT-003: ディスク空き容量600KB以上を確認 | E-02 (JobManager.vb:153) | ○ |
| C-04 | NFT-004: 並列プロセス数がParallelProcsNumで制御される | E-03 (ApplicationSettings.vb:68) | ○ |
| C-05 | NFT-005: ジョブファイルアクセスで最大10回リトライ | E-02 (JobManager.vb:129,168) | ○ |
| C-06 | NFT-006: スタンバイ抑制機能が実装されている | E-04 (General.vb:1407-1421) | ○ |
| C-07 | NFT-007: Abort/Skip後にMainFormが復旧される | E-01 (ProcController.vb:723-738,843-868) | ○ |
| C-08 | NFT-008: プロセス終了時にリソースがクリーンアップされる | E-01 (ProcController.vb:800-841) | ○ |
| C-09 | NFT-009: 管理者権限がWindowsPrincipalで確認される | E-05 (GlobalClass.vb:24) | ○ |
| C-10 | NFT-010: ファイルパスに不正文字チェックが行われる | E-06 (Project.vb:291) | ○ |
| C-11 | NFT-011: ファイル名の有効性検証が行われる | E-06 (Project.vb:291) | ○ |
| C-12 | NFT-012: Windows 7互換性警告設定が存在する | E-03 (ApplicationSettings.vb:96) | ○ |
| C-13 | NFT-013: CUDAデバイス検出機能が実装されている | E-04 (General.vb:1488-1508) | ○ |
| C-14 | NFT-014: Vulkanサポート検出機能が実装されている | E-04 (General.vb:1510-1536) | ○ |
| C-15 | NFT-015: ツールバージョン検証設定が存在する | E-03 (ApplicationSettings.vb:11) | ○ |
| C-16 | NFT-016: ログファイル数制限設定が存在する | E-03 (ApplicationSettings.vb:63) | ○ |
| C-17 | NFT-017: SafeSerializationによる設定保存が実装されている | E-04 (General.vb:294-431) | ○ |
| C-18 | NFT-018: WasUpdatedによるバージョン移行が実装されている | E-04 (General.vb:433-437) | ○ |
| C-19 | NFT-019: フォーカススティール防止設定が存在する | E-03 (ApplicationSettings.vb:71-72) | ○ |
| C-20 | NFT-020: システムトレイ最小化機能が実装されている | E-07 (ProcessingForm.vb:298-305) | ○ |
| C-21 | NFT-021: 大容量ファイル処理時のメモリ管理 | **根拠なし** | △ |
| C-22 | NFT-022: Suspend/Resume機能が実装されている | E-01 (ProcController.vb:740-759) | ○ |
| C-23 | NFT-023: ThreadExceptionハンドラが設定されている | E-07 (ProcessingForm.vb:213) | ○ |
| C-24 | NFT-024: シャットダウン制御機能が実装されている | E-04 (General.vb:1372-1394) | ○ |
| C-25 | NFT-025: コマンドライン引数解析が実装されている | E-04 (General.vb:854-899) | ○ |
| C-26 | NFT-026: ロングパスサポート確認設定が存在する | E-03 (ApplicationSettings.vb:18) | ○ |
| C-27 | NFT-027: アップデート確認機能設定が存在する | E-03 (ApplicationSettings.vb:19-21) | ○ |
| C-28 | NFT-028: テーマ切り替え機能が実装されている | E-07 (ProcessingForm.vb:270-278) | ○ |
| C-29 | NFT-029: プロセス優先度設定が存在する | E-03 (ApplicationSettings.vb:76) | ○ |
| C-30 | NFT-030: プロジェクト自動保存設定が存在する | E-03 (ApplicationSettings.vb:13) | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-021（大容量ファイル処理）**：明示的なメモリ制限値やストリーミング処理方式の要件定義がコード内に見当たらない
  - 候補：要件定義書 / 設計書 / パフォーマンステスト結果
- **NFT-027（アップデート確認）**：更新確認のタイムアウト値やSLA定義がない
  - 候補：運用要件書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：NFT-021 大容量ファイル処理に関する明示的な制限値がないため、境界条件のテストケース設計が困難
- **リスク0（低）**：NFT-027 アップデート確認の具体的な動作仕様は外部サービス依存のため、テストケースの合格基準が曖昧

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-001〜NFT-005の性能テスト項目が実際の性能要件と整合しているか確認
- [ ] NFT-006〜NFT-008の可用性テスト項目がシステムの可用性要件を網羅しているか確認
- [ ] NFT-009〜NFT-011のセキュリティテスト項目がセキュリティポリシーと整合しているか確認
- [ ] NFT-021の大容量ファイル処理について、メモリ制限の具体的な基準を追加定義するか検討
- [ ] 優先度「高」のテストケースから実施計画を策定
- [ ] 各テストケースの「合格基準」が測定可能な形式になっているか確認
