---
generated_at: 2026-01-21 19:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された非機能要件定義書の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **UI表示応答時間200ms**：明示的な設定値の根拠なし
  2. **プロセス優先度の詳細設定**：実行時の挙動確認が必要
  3. **Windows 7互換性制限**：READMEの記述のみで実装コードでの検証未実施

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/app.config` - .NET Framework 4.8、High DPI設定、キャッシュタイムアウト
- E-02: `Source/General/JobManager.vb` - ジョブファイルI/O、リトライ機構、ディスク空き容量チェック
- E-03: `Source/General/GlobalClass.vb` - IsAdmin判定、MAX_PATH、イベント定義
- E-04: `Source/General/General.vb` - Folder設定、SafeSerialization、電源管理
- E-05: `Source/General/LogBuilder.vb` - ログ出力、環境情報記録、統計情報
- E-06: `Source/General/ProcController.vb` - プロセス制御、サスペンド/レジューム、進捗管理
- E-07: `Source/General/Project.vb` - プロジェクト設定、DeleteTempFilesMode
- E-08: `Source/Forms/ProcessingForm.vb` - UI制御、優先度設定、シャットダウン制御
- E-09: `Source/Forms/DownloadForm.vb` - WebClientダウンロード、User-Agent設定
- E-10: `README.md` - システム要件、Windows 7制限
- E-11: `CHANGELOG.md` - バージョン履歴、機能追加情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET Framework 4.8が必要 | E-01 | ○ |
| C-02 | High DPI自動リサイズ対応 | E-01 | ○ |
| C-03 | ロールキャッシュタイムアウト86400秒 | E-01 | ○ |
| C-04 | ジョブファイルI/Oで最大10回リトライ | E-02 | ○ |
| C-05 | Thread.Sleep(500)でリトライ間隔制御 | E-02 | ○ |
| C-06 | ディスク空き容量600KB以上チェック | E-02 | ○ |
| C-07 | BinaryFormatterによるシリアライゼーション | E-02, E-04 | ○ |
| C-08 | IsAdmin判定機能あり | E-03 | ○ |
| C-09 | MAX_PATH=260の制限認識 | E-03 | ○ |
| C-10 | ApplicationEventによるイベント通知 | E-03 | ○ |
| C-11 | 設定ディレクトリ選択機能（3オプション） | E-04 | ○ |
| C-12 | SafeSerializationによるバージョン管理 | E-04 | ○ |
| C-13 | FileIOPermissionによるパス検証 | E-04 | ○ |
| C-14 | 電源管理（スタンバイ/休止/シャットダウン） | E-04, E-08 | ○ |
| C-15 | ES_SYSTEM_REQUIREDによるスリープ防止 | E-04 | ○ |
| C-16 | CRC32ハッシュ計算機能 | E-04 | ○ |
| C-17 | CUDA検出機能（ManagedCuda） | E-04 | ○ |
| C-18 | Vulkan検出・バージョン取得機能 | E-04 | ○ |
| C-19 | LogBuilderによるスレッドセーフログ | E-05 | ○ |
| C-20 | UTF-8ファイル出力 | E-05 | ○ |
| C-21 | 環境情報記録（OS、CPU、RAM、GPU） | E-05 | ○ |
| C-22 | 構成情報記録（テンプレート、エンコーダー） | E-05 | ○ |
| C-23 | 処理統計記録（開始/終了/所要時間） | E-05 | ○ |
| C-24 | プロセス優先度制御（6段階） | E-06, E-08 | ○ |
| C-25 | SuspendThread/ResumeThread実装 | E-06 | ○ |
| C-26 | 進捗更新200ms間隔制御 | E-06 | ○ |
| C-27 | 複数プロセス管理機能 | E-06 | ○ |
| C-28 | タスクバー進捗表示連携 | E-06, E-08 | ○ |
| C-29 | NotifyIconシステムトレイ連携 | E-08 | ○ |
| C-30 | AbortException/SkipExceptionによる制御 | E-04, E-06 | ○ |
| C-31 | プロジェクトファイル.srip形式 | E-04, E-07 | ○ |
| C-32 | 一時ファイル削除設定機能 | E-07 | ○ |
| C-33 | フレームミスマッチ警告機能 | E-07 | ○ |
| C-34 | WebClientダウンロード機能 | E-09 | ○ |
| C-35 | User-Agentヘッダー設定 | E-09 | ○ |
| C-36 | Refererヘッダー設定 | E-09 | ○ |
| C-37 | Windows 8以降推奨 | E-10 | ○ |
| C-38 | ポータブルアプリケーション設計 | E-10 | ○ |
| C-39 | Visual C++ランタイム必要 | E-10 | ○ |
| C-40 | テンプレートバックアップ機能 | E-04 | ○ |
| C-41 | Migrate機能による設定移行 | E-07 | ○ |
| C-42 | グローバル例外ハンドラー | E-08 | ○ |
| C-43 | UI表示応答時間200ms以内 | **根拠なし** | △ |
| C-44 | 同時エンコーディングジョブ1ジョブ制限 | **根拠不足** | △ |
| C-45 | AviSynthメモリ上限設定機能 | **avisynth.h参照のみ** | △ |

## 4) 不足情報（Unknown / Missing）
- **UI応答時間の目標値**：明示的な設定やベンチマークコードが存在しない。一般的なUI設計のベストプラクティスに基づく推定値。
  - 候補：パフォーマンステスト実施 / UI応答時間測定コードの確認 / 要件文書の確認
- **同時ジョブ数制限**：ジョブキュー管理コードは確認したが、明示的な「1ジョブのみ」の制限コードは特定できず。実行時の挙動から推測。
  - 候補：JobManager.vb詳細解析 / 並列処理コードの確認 / ユーザードキュメントの確認
- **AviSynthメモリ上限**：avisynth.hにSetMemoryMax定義を確認したが、StaxRip側での呼び出し箇所の詳細確認が必要。
  - 候補：VideoScript.vb解析 / フィルタープロファイル確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：.NET Framework要件、基本的なファイルI/O、ログ機能
- **0（低リスク）**：電源管理、プロセス制御の基本機能
- **1（中リスク）**：Windows 7互換性に関する記述（READMEベースの情報）
- **1（中リスク）**：外部ツール連携に関する要件（ツール固有の要件は含まれていない）
- **2（高リスク）**：UI応答時間の目標値（根拠なしの推定値）

## 6) レビュアーチェックリスト（最小）
- [ ] C-43（UI応答時間200ms）の妥当性を実機テストで確認
- [ ] C-44（同時ジョブ制限）の実装を詳細コードレビューで確認
- [ ] C-45（AviSynthメモリ上限）の呼び出し箇所をVideoScript.vbで確認
- [ ] Windows 7での動作制限について、実機またはVMでの検証が必要か判断
- [ ] 外部ツール（x265、ffmpeg等）の個別非機能要件の追記が必要か検討
- [ ] セキュリティ要件について、入力検証やファイルパス検証の詳細確認
