# 非機能要件定義書

## 概要

本ドキュメントは、StaxRip（Windows向けビデオ/オーディオエンコーディングGUIアプリケーション）における非機能要件を定義する。StaxRipは、x265、mkvmerge、ffmpegなどのコンソールアプリケーションを制御し、AviSynth+およびVapourSynthを使用したビデオ処理を行うデスクトップアプリケーションである。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| UI表示・操作応答 | 200ms以内 | High DPI自動リサイズ対応による最適化実装済み |
| ジョブファイル読み込み | 5秒以内（リトライ含む） | Thread.Sleep(500)での5秒リトライ機構を実装 |
| ジョブファイル保存 | 500ms以内 | Thread.Sleep(100)での同期処理実装 |
| プログレス更新 | 200ms間隔 | _lastProgressSet >= Date.Now.AddMilliseconds(-200)による制御 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時エンコーディングジョブ | 1ジョブ | シングルジョブ処理設計（キュー管理あり） |
| バッチ処理ジョブ数 | 無制限 | ジョブキュー管理機能搭載 |
| 並列プロセス制御 | 複数プロセス対応 | ProcControllerによる複数プロセス管理 |

### メモリ・リソース管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| AviSynthメモリ上限 | ユーザー設定可能 | SetMemoryMax関数による制御 |
| ディスク空き容量チェック | 600KB以上 | GetDiskFreeSpaceExによる保存前検証 |
| ロールキャッシュタイムアウト | 86400秒（24時間） | ClientRoleProvider設定 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | N/A（デスクトップアプリ） | スタンドアロンアプリケーション |
| 計画停止時間 | N/A | オフラインで動作可能 |
| 障害復旧時間（RTO） | 即時 | 一時ファイル削除による復旧可能 |
| 目標復旧時点（RPO） | 最終保存時点 | ジョブファイル（.srip）による状態保存 |

### 耐障害性

| 機能 | 実装内容 | 備考 |
| --- | --- | --- |
| ジョブファイルI/Oリトライ | 最大10回リトライ | GetJobs/SaveJobs内でThread.Sleep(500)による間隔 |
| プロセス中断・再開 | サスペンド/レジューム機能 | SuspendThread/ResumeThread API使用 |
| エラー時アボート | AbortException/ErrorAbortException | 例外によるグレースフルな終了処理 |
| スキップ機能 | SkipException | 現在のジョブをスキップし次ジョブ継続 |

### 電源管理

| 機能 | 説明 | 備考 |
| --- | --- | --- |
| スタンバイ抑止 | ES_SYSTEM_REQUIRED | エンコーディング中のスリープ防止 |
| シャットダウン制御 | スタンバイ/休止/シャットダウン | ジョブ完了後の自動電源操作 |
| シャットダウンタイムアウト | ユーザー設定可能 | s.ShutdownTimeout設定 |

## セキュリティ要件

### 権限管理

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 管理者権限チェック | WindowsPrincipal/WindowsIdentity | IsAdminプロパティで判定 |
| ファイルパス権限検証 | FileIOPermission | フォルダパス取得時にPathDiscovery要求 |
| 設定ディレクトリ選択 | 複数選択肢提供 | Startup/AppDataRoaming/AppDataCommon |

### データ保護

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| プロジェクトファイル形式 | BinaryFormatter/SafeSerialization | バイナリシリアライゼーション |
| ロングパスサポート | LongPathPrefix | \\?\プレフィックスによる長いパス対応 |
| 一時ファイル管理 | 選択的削除機能 | DeleteTempFilesMode設定 |

### 通信セキュリティ

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| ダウンロード | HTTPS推奨 | WebClientによるファイルダウンロード |
| User-Agent設定 | ブラウザ偽装 | Mozilla/5.0ヘッダー設定 |
| Referer設定 | URL設定 | ダウンロード元URLをRefererに設定 |

## 拡張性要件

### モジュール性

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| プラグインシステム | AviSynth/VapourSynthプラグイン | Pluginsディレクトリによる拡張 |
| スクリプト機能 | PowerShell統合 | System.Management.Automation使用 |
| イベントコマンド | カスタムイベント処理 | ApplicationEvent/EventCommands |
| プロファイル管理 | テンプレート機能 | .sripファイルによるワークフロー保存 |

### 外部ツール連携

| 項目 | 対応ツール例 | 備考 |
| --- | --- | --- |
| ビデオエンコーダー | x264, x265, SVT-AV1, rav1e, aomenc, NVEncC, QSVEncC, VCEEncC | 複数エンコーダー対応 |
| オーディオツール | ffmpeg, eac3to | 音声処理 |
| コンテナツール | mkvmerge, MP4Box | マルチプレクス処理 |
| フレームサーバー | AviSynth+, VapourSynth | スクリプト処理 |

## 保守性要件

### ログ機能

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| ログ出力 | LogBuilder | StringBuilder使用、スレッドセーフ |
| ログ保存 | UTF-8ファイル出力 | _staxrip.logとして保存 |
| 環境情報記録 | WriteEnvironment | OS、CPU、RAM、GPU情報記録 |
| 構成情報記録 | WriteConfiguration | テンプレート、エンコーダー設定記録 |
| 処理統計 | WriteStats | 開始・終了時刻、所要時間記録 |

### 設定管理

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 設定保存形式 | SafeSerialization | バイナリ形式、バージョン管理機能付き |
| 設定バックアップ | Templatesバックアップ | テンプレート更新時に自動バックアップ |
| 設定移行 | Migrate機能 | 旧バージョン設定の自動変換 |
| プロファイル分離保存 | 個別datファイル | VideoEncoderProfiles.dat等 |

### コード品質

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 例外処理 | グローバル例外ハンドラー | g.OnUnhandledException |
| リソース解放 | IDisposable実装 | Using/Disposeパターン |
| スレッド同期 | SyncLock | ログ・プロセス管理の排他制御 |

## 運用・監視要件

### プロセス管理

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| プロセス優先度制御 | ProcessPriorityClass | Realtime/High/Normal/Low等設定可能 |
| プロセス監視 | ProcController | 複数プロセスの状態管理 |
| タスクバー連携 | Taskbar API | 進捗表示、通知アイコン |

### 進捗表示

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| プログレスバー | LabelProgressBar | パーセント表示 |
| 出力ハイライト | RichTextBox | シンタックスハイライト機能 |
| 通知アイコン | NotifyIcon | システムトレイ連携 |
| 最小化時動作 | MinimizeToTray | トレイ最小化対応 |

### エラー通知

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| エラーダイアログ | TaskDialog | MsgError/MsgWarn/MsgInfo |
| フレームミスマッチ警告 | AbortOnFrameMismatch | フレーム数不一致時の処理選択 |
| 完了通知 | ApplicationEvent | AfterJobsProcessed等イベント |

## 互換性要件

### システム要件

| 項目 | 要件 | 備考 |
| --- | --- | --- |
| OS | Windows 8以降推奨 | Windows 7は一部機能制限 |
| .NET Framework | 4.8 | app.config定義 |
| Visual C++ランタイム | 複数バージョン必要 | vcredist All-in-One推奨 |

### ハードウェアサポート

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| CUDA | ManagedCuda | NVIDIA GPU検出・利用 |
| Vulkan | vkEnumerateInstanceVersion | HDRトーンマッピング等 |
| High DPI | EnableWindowsFormsHighDpiAutoResizing | 高解像度ディスプレイ対応 |

## 備考

- StaxRipはポータブルアプリケーションとして設計されており、インストール不要で動作する
- 設定ディレクトリはユーザー選択可能（Startup/AppData等）
- ジョブ処理は非同期で実行され、UIスレッドとは分離されている
- 多数の外部ツールと連携するため、各ツールの個別要件も考慮が必要
