# stdVBA

## 概要

stdVBAは、モダンなVBAアプリケーション開発のための共通標準ライブラリコレクションです。JavaScriptのAPIに強くインスパイアされており、VBAの古い言語仕様を補完し、汎用的で再利用可能なライブラリを提供することで、VBA開発の効率と保守性を向上させます。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| 型操作 (Types) | stdArray, stdEnumerator, stdDictionary, stdRegex, stdLambda, stdCallback等の動的配列、列挙、正規表現、ラムダ関数ライブラリ |
| データ処理 (Data) | stdJSON等のデータフォーマット処理ライブラリ |
| 自動化 (Automation) | stdClipboard, stdWindow, stdProcess, stdAcc, stdWebSocket等のクリップボード、ウィンドウ、プロセス、アクセシビリティ操作 |
| COM操作 | stdCOM - リフレクション、インターフェースクエリ、DispIDによるメソッド呼び出し等 |
| パフォーマンス | stdPerformance - パフォーマンステスト用ライブラリ |
| HTTP通信 | stdHTTP - Win HTTPライブラリのラッパー |
| 画像処理 | stdImage - 画像操作ライブラリ |

## 技術スタック

### コア

- 言語: VBA (Visual Basic for Applications)
- 対応アプリケーション: Microsoft Excel, Word, PowerPoint, Access, Outlook, Publisher
- 対応プラットフォーム: Windows (Win32 API), Mac (libc.dylib)

### 主要ライブラリ

- Win32 API (kernel32, VBE7.dll等)
- Microsoft Active Accessibility (MSAA)
- COM (Component Object Model)
- WinHTTP

## ディレクトリ構成

```
stdVBA-master/
├── src/                          # メインソースコード
│   ├── stdArray.cls              # 動的配列クラス
│   ├── stdLambda.cls             # ラムダ関数クラス
│   ├── stdRegex.cls              # 正規表現クラス
│   ├── stdCallback.cls           # コールバッククラス
│   ├── stdEnumerator.cls         # 列挙子クラス
│   ├── stdWindow.cls             # ウィンドウ操作クラス
│   ├── stdProcess.cls            # プロセス管理クラス
│   ├── stdClipboard.cls          # クリップボード管理クラス
│   ├── stdAcc.cls                # アクセシビリティクラス
│   ├── stdCOM.cls                # COM操作クラス
│   ├── stdJSON.cls               # JSON処理クラス
│   ├── stdHTTP.cls               # HTTP通信クラス
│   ├── stdImage.cls              # 画像処理クラス
│   ├── stdPerformance.cls        # パフォーマンステストクラス
│   ├── stdICallable.cls          # コーラブルインターフェース
│   └── WIP/                      # 開発中のモジュール
│       ├── stdDate.cls           # 日付処理（WIP）
│       ├── stdDictionary/        # 辞書型（WIP）
│       ├── stdShell.cls          # シェル操作（WIP）
│       ├── stdTable/             # テーブル操作（WIP）
│       └── ...                   # その他WIPモジュール
├── tests/                        # テストコード
│   ├── lib/                      # テスト用ライブラリ
│   ├── stdArrayTests.bas         # stdArrayテスト
│   ├── stdLambdaTests.bas        # stdLambdaテスト
│   └── ...                       # 各モジュールのテスト
├── docs/                         # ドキュメント
│   ├── stdLambda.md              # stdLambdaドキュメント
│   ├── stdEnumerator.md          # stdEnumeratorドキュメント
│   ├── stdWindow.md              # stdWindowドキュメント
│   ├── stdAcc.md                 # stdAccドキュメント
│   └── assets/                   # ドキュメント用アセット
├── Tools/                        # 開発ツール
│   ├── VBDocsGen/                # ドキュメント生成ツール
│   ├── VBALibraries Extract/     # ライブラリ抽出ツール
│   └── VBA-stdError-Wrapper/     # エラーラッパーツール
├── Templates/                    # テンプレート
├── fullBuild.xlsm                # フルビルド用Excelファイル
├── testBuilder.xlsm              # テストビルダー用Excelファイル
├── docs.json                     # ドキュメント定義JSON
├── changelog.md                  # 変更履歴
├── contribution.md               # コントリビューションガイド
├── LICENSE                       # MITライセンス
└── README.md                     # プロジェクトREADME
```

## セットアップ

### 必要条件

- Microsoft Office (Excel, Word, PowerPoint, Access等)のVBAエディタが使用可能であること
- Windows環境（一部機能はMacにも対応）

### インストール手順

1. このリポジトリをクローンまたはダウンロード
2. 使用したいモジュール（.clsファイル）をWindowsエクスプローラーからVBAプロジェクトにドラッグ&ドロップ
3. または、VBAエディタでファイル > インポートを使用

```vb
' 基本的な使用例
Sub Example()
    Dim arr As stdArray
    Set arr = stdArray.Create(1, 2, 3, 4, 5)

    ' フィルタリング（偶数のみ）
    Set arr = arr.Filter(stdLambda.Create("$1 mod 2 = 0"))

    ' 結果表示
    Debug.Print arr.Join(",")  ' => "2,4"
End Sub
```

### 重要な設定

- 各クラスファイルは `Attribute VB_PredeclaredId = True` が設定されている必要があります
- 行末は `\r\n` (CRLF) である必要があります
- Gitフィルターを有効にするには: `git config include.path ../.gitconfig`

## 開発

### コーディング規約

- すべてのモジュール/クラスは `std` プレフィックスを使用（例: `stdArray`）
- インターフェースは `stdI` プレフィックスを使用（例: `stdICallable`）
- アプリケーション固有のライブラリは `xl`, `wd`, `pp`, `ax` プレフィックスを使用
- コンストラクタは `Create` で始める（例: `stdArray.Create(...)`）
- 保護されたメソッドは `prot` プレフィックスを使用（例: `protInit`）

### 状態管理パターン

```vb
Private Type TThis
    State1 As String
    IsStateEnabled As Boolean
End Type
Private This As TThis
```

### テスト実行

テストは `testBuilder.xlsm` を使用して実行できます。各モジュールには対応するテストファイルが `tests/` ディレクトリに存在します。

### ドキュメント生成

`Tools/VBDocsGen` を使用してJSDocスタイルのコメントからドキュメントを生成できます。

### コントリビューション

1. 新機能やバグ報告は [GitHub Issues](https://github.com/sancarn/stdVBA/issues) で受け付けています
2. プルリクエストでのコード提供が最も簡単な貢献方法です
3. 詳細は `contribution.md` を参照してください

## ライセンス

MIT License - Copyright (c) 2021 James Warren
