---
generated_at: 2026-01-15 21:30:00
metrics:
  claims_total: 52
  claims_with_evidence: 49
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：49 / 52、根拠なし：3
- 優先レビュー（高）
  1. **アプリケーション固有プレフィックス（wd, pp, ax）の使用状況**：実際のコードで確認できず
  2. **xlTable等のExcel固有クラスの実装状態**：WIPディレクトリに存在するが完成度不明
  3. **YouTube動画シリーズの内容詳細**：外部リンクのため内容未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`
- E-02: `contribution.md`
- E-03: `src/stdArray.cls`
- E-04: `src/stdLambda.cls`
- E-05: `src/stdCallback.cls`
- E-06: `src/stdRegex.cls`
- E-07: `src/stdEnumerator.cls`
- E-08: `src/stdICallable.cls`
- E-09: `src/stdWindow.cls`
- E-10: `src/stdProcess.cls`
- E-11: `Templates/ClassTemplate.cls`
- E-12: `tests/Main.bas`
- E-13: `tests/lib/Test.cls`
- E-14: `tests/stdArrayTests.bas`
- E-15: `docs/stdLambda.md`
- E-16: `changelog.md`
- E-17: `src/WIP/` ディレクトリ構造
- E-18: `src/stdHTTPAuthenticators.bas`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stdVBAはVBA標準ライブラリコレクション | E-01 | ○ |
| C-02 | JavaScript風APIを提供 | E-01 | ○ |
| C-03 | VB_PredeclaredId = True で静的クラス動作 | E-03, E-04, E-05 | ○ |
| C-04 | VB_Nameでクラス名定義 | E-03 | ○ |
| C-05 | Private Type TThisパターンで状態管理 | E-03, E-04, E-05 | ○ |
| C-06 | Dimで変数宣言、Asで型指定 | E-03 | ○ |
| C-07 | Long, String, Boolean, Variant等の型 | E-03, E-04 | ○ |
| C-08 | Functionは戻り値あり、Subは戻り値なし | E-03, E-05 | ○ |
| C-09 | Public, Private, Friendアクセス修飾子 | E-11, E-03 | ○ |
| C-10 | Implementsでインターフェース実装 | E-04 | ○ |
| C-11 | ファクトリーパターンをすべてのクラスで採用 | E-11, E-01, E-02 | ○ |
| C-12 | Createメソッドでインスタンス生成 | E-03, E-04, E-05, E-06 | ○ |
| C-13 | protInitで内部初期化 | E-11, E-03, E-04 | ○ |
| C-14 | stdICallableが共通インターフェース | E-08, E-04, E-05 | ○ |
| C-15 | Run, RunEx, Bind, SendMessageメソッド | E-08 | ○ |
| C-16 | $1, $2でラムダ引数参照 | E-15, E-01 | ○ |
| C-17 | Map, Filter, Reduceメソッド | E-03, E-01 | ○ |
| C-18 | Win32 API宣言の条件付きコンパイル | E-03, E-09, E-10 | ○ |
| C-19 | #If Mac, VBA7, Win64 条件 | E-03, E-09 | ○ |
| C-20 | std{Name}.cls命名規則 | E-03, E-04, E-05 | ○ |
| C-21 | stdI{Name}.clsインターフェース命名 | E-08 | ○ |
| C-22 | std{Name}.bas補助モジュール命名 | E-18 | ○ |
| C-23 | xl{Name}はExcel固有クラス | E-02 | ○ |
| C-24 | wd, pp, axプレフィックス使用 | E-02 | △ |
| C-25 | Create, CreateFrom{Source}命名規則 | E-09, E-10 | ○ |
| C-26 | prot prefix for protected | E-11, E-03 | ○ |
| C-27 | s, i, b, o, v プレフィックス | E-04, E-05 | ○ |
| C-28 | T{Name}でType定義 | E-03, E-04 | ○ |
| C-29 | srcにメインソースコード | ディレクトリ構造 | ○ |
| C-30 | src/WIPに開発中コード | E-17 | ○ |
| C-31 | testsにテストコード | E-12 | ○ |
| C-32 | tests/libにテストフレームワーク | E-13 | ○ |
| C-33 | docsにドキュメント | E-15 | ○ |
| C-34 | Templatesにテンプレート | E-11 | ○ |
| C-35 | ライブラリコレクションアーキテクチャ | E-01, E-02 | ○ |
| C-36 | クラス間の依存関係最小化 | E-02 | ○ |
| C-37 | Types, Data, Automationレイヤー分類 | E-01 | ○ |
| C-38 | 関数型プログラミングスタイル推奨 | E-01, E-15 | ○ |
| C-39 | stdArrayにMap, Filter, Reduce | E-03, E-14 | ○ |
| C-40 | stdRegexにキャッシュ機能 | E-06 | ○ |
| C-41 | Test.clsでAssert, Topic, Refresh | E-13 | ○ |
| C-42 | イベント駆動拡張（stdArray） | E-03 | ○ |
| C-43 | BeforeAdd, AfterAddイベント | E-03 | ○ |
| C-44 | stdLambdaでIInstruction定義 | E-04 | ○ |
| C-45 | stdCallbackでParentType定義 | E-05 | ○ |
| C-46 | MainTestAllでテスト実行 | E-12 | ○ |
| C-47 | xlTableのWIP状態 | E-17 | △ |
| C-48 | YouTube動画シリーズ存在 | E-01 | △ |
| C-49 | GitHub Examples リポジトリ存在 | E-01 | ○ |
| C-50 | changelog.mdで変更履歴管理 | E-16 | ○ |
| C-51 | CriticalRaiseでエラー処理 | E-03, E-05 | ○ |
| C-52 | LongPtr型の32/64ビット対応 | E-05, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-24: アプリケーション固有プレフィックス（wd, pp, ax）**
  - contribution.mdでは言及されているが、実際のソースコードでの使用例が確認できなかった
  - 候補：src/WIP/stdWordLibraries/ / 将来の実装 / ドキュメントのみの規約

- **C-47: xlTableの完成度**
  - src/WIP/stdTable/に存在するが、WIPディレクトリのため完成状態不明
  - 候補：実装中 / 一部完成 / 実験的

- **C-48: YouTube動画シリーズの内容**
  - README.mdにリンクは存在するが、動画内容の詳細は外部リソースのため未確認
  - 候補：存在確認済み / リンク切れの可能性 / 内容変更の可能性

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 言語基礎（VBA構文）の解説
  - VBA公式ドキュメントと照合可能

- **0（低リスク）**: ファクトリーパターンの解説
  - コードと直接照合可能

- **0（低リスク）**: ディレクトリ構造
  - 実際のファイル構造と照合可能

- **1（中リスク）**: アーキテクチャ図
  - ソースコードからの推論に基づく
  - レイヤー分類は解釈による

- **1（中リスク）**: 外部リソースへのリンク
  - リンク切れの可能性
  - 内容変更の可能性

- **0（低リスク）**: コード例
  - 実際のソースコードから直接引用

## 6) レビュアーチェックリスト（最小）

- [ ] VBA基礎構文の説明が正確か（Section 1）
- [ ] ファクトリーパターンの説明がソースコードと一致するか（Section 2.1）
- [ ] stdICallableインターフェースの説明が正確か（Section 2.2）
- [ ] 命名規則がcontribution.mdと一致するか（Section 3）
- [ ] ディレクトリ構造が実際のプロジェクト構造と一致するか（Section 4）
- [ ] アーキテクチャ図が実際の依存関係を反映しているか（Section 5）
- [ ] コード例がソースファイルの該当行と一致するか（全セクション）
- [ ] 外部リンク（GitHub, YouTube）が有効か（Section 9, 付録C）
- [ ] WIPディレクトリのクラスについての説明が適切か（Section 4）
- [ ] 用語集の定義が正確か（付録A）
