# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発環境"
        DEV[開発者]
        LOCAL[ローカル環境<br/>Microsoft Office + VBA]
        VSCODE[VS Code<br/>VBA-STD.code-workspace]
    end

    subgraph "GitHub Platform"
        subgraph "リポジトリ"
            REPO[GitHub Repository<br/>sancarn/stdVBA]
            MASTER[masterブランチ]
            LINTING[lintingブランチ]
            WRAPPED[stdError-Wrappedブランチ]
        end

        subgraph "GitHub Actions CI/CD"
            GA_LINT[Lint VBA<br/>ワークフロー]
            GA_DOCS[VBA Docs Generator<br/>ワークフロー]
            GA_CRLF[Enforce CRLF<br/>ワークフロー]
            GA_ERROR[stdError Wrapper<br/>ワークフロー]
        end

        subgraph "GitHub Runners"
            RUNNER[ubuntu-latest<br/>Runner]
        end

        PAGES[GitHub Pages<br/>ドキュメント配信]
    end

    subgraph "外部サービス"
        PYPI[PyPI<br/>vba_precompiler]
        NPM[npm Registry<br/>Node.js依存]
    end

    DEV --> |git push| REPO
    DEV --> LOCAL
    DEV --> VSCODE

    REPO --> MASTER
    REPO --> LINTING
    REPO --> WRAPPED

    MASTER --> |push trigger| GA_CRLF
    MASTER --> |push trigger| GA_ERROR
    MASTER --> |push trigger| GA_DOCS
    LINTING --> |push trigger| GA_LINT

    GA_LINT --> RUNNER
    GA_DOCS --> RUNNER
    GA_CRLF --> RUNNER
    GA_ERROR --> RUNNER

    RUNNER --> |pip install| PYPI
    RUNNER --> |npm install| NPM

    GA_ERROR --> |force push| WRAPPED
    GA_DOCS --> |commit| REPO
    GA_CRLF --> |commit| REPO

    REPO --> |deploy| PAGES
```

## CI/CDパイプライン詳細図

```mermaid
flowchart LR
    subgraph "トリガー"
        T1[push to master]
        T2[push to linting]
        T3[PR to master]
        T4[手動実行]
    end

    subgraph "Lint VBA Pipeline"
        L1[Checkout]
        L2[Python Setup]
        L3[vba_precompiler Install]
        L4[Precompile VBA]
        L5[Lint Check]
    end

    subgraph "Docs Generator Pipeline"
        D1[Checkout]
        D2[Node.js 20 Setup]
        D3[Run VBDocsGen]
        D4[Commit docs.json]
        D5[Push to origin]
    end

    subgraph "Enforce CRLF Pipeline"
        C1[Checkout]
        C2[Enforce-CRLF Action]
        C3[Auto Push]
    end

    subgraph "stdError Wrapper Pipeline"
        E1[Checkout]
        E2[Node.js 20 Setup]
        E3[Run Wrapper Tool]
        E4[Commit Changes]
        E5[Force Push to stdError-Wrapped]
    end

    T2 --> L1 --> L2 --> L3 --> L4 --> L5

    T1 --> D1 --> D2 --> D3 --> D4 --> D5
    T1 --> C1 --> C2 --> C3
    T1 --> E1 --> E2 --> E3 --> E4 --> E5

    T3 --> C1
    T4 --> E1
```

## ディレクトリ構造図

```mermaid
graph TB
    ROOT["stdVBA-master/"]

    ROOT --> SRC["src/<br/>VBAソースコード"]
    ROOT --> TESTS["tests/<br/>テストコード"]
    ROOT --> DOCS["docs/<br/>ドキュメント"]
    ROOT --> TOOLS["Tools/<br/>開発ツール"]
    ROOT --> GH[".github/<br/>GitHub設定"]
    ROOT --> TEMPLATES["Templates/<br/>テンプレート"]
    ROOT --> LOGS["logs/<br/>ログ"]

    SRC --> CLS[".cls ファイル<br/>stdArray, stdLambda等"]
    SRC --> BAS[".bas ファイル<br/>stdHTTPAuthenticators等"]

    TESTS --> TEST_BAS[".bas テストファイル"]
    TESTS --> TEST_LIB["lib/<br/>テストヘルパー"]

    DOCS --> DOC_MD["*.md<br/>ドキュメント"]
    DOCS --> DOC_WIP["WIP/<br/>作成中ドキュメント"]
    DOCS --> DOC_ASSETS["assets/<br/>画像等"]

    TOOLS --> VBDOCS["VBDocsGen/<br/>ドキュメント生成ツール"]
    TOOLS --> VBERROR["VBA-stdError-Wrapper/<br/>エラーラッパーツール"]
    TOOLS --> VBLIB["VBALibraries Extract/<br/>ライブラリ抽出ツール"]

    GH --> WORKFLOWS[".github/workflows/<br/>CI/CDワークフロー"]

    WORKFLOWS --> W_LINT["lint_vba.yml"]
    WORKFLOWS --> W_DOCS["vba_docs_gen.yml"]
    WORKFLOWS --> W_CRLF["enforce_crlf.yml"]
    WORKFLOWS --> W_ERROR["stdError_wrap.yml"]
```

## ブランチ戦略図

```mermaid
gitGraph
    commit id: "initial"
    branch linting
    checkout linting
    commit id: "lint setup"
    checkout main
    commit id: "feature A"
    commit id: "feature B"
    branch stdError-Wrapped
    checkout stdError-Wrapped
    commit id: "auto-wrapped"
    checkout main
    commit id: "feature C"
    checkout stdError-Wrapped
    commit id: "auto-wrapped 2" type: HIGHLIGHT
```

| ブランチ | 用途 | 更新方法 |
|---------|------|---------|
| master | メイン開発ブランチ | 手動push/PR |
| linting | Lint実行用ブランチ | 手動push |
| stdError-Wrapped | stdErrorラッパー適用済みコード | GitHub Actions自動フォースプッシュ |

## 開発ワークフロー図

```mermaid
sequenceDiagram
    participant Dev as 開発者
    participant Local as ローカル環境
    participant GitHub as GitHub
    participant Actions as GitHub Actions
    participant Pages as GitHub Pages

    Dev->>Local: VBAコード編集
    Dev->>Local: ローカルテスト（Excel）
    Dev->>GitHub: git push

    GitHub->>Actions: ワークフロートリガー

    par 並列実行
        Actions->>Actions: Enforce CRLF
        Actions->>Actions: VBA Docs Generator
        Actions->>Actions: stdError Wrapper
    end

    Actions->>GitHub: 自動コミット
    GitHub->>Pages: デプロイ
    Pages-->>Dev: ドキュメント更新確認
```

## ツール依存関係図

```mermaid
graph LR
    subgraph "VBDocsGen"
        VBD[main.ts]
        VBD_JS[main.js]
        VBD_PKG[package.json]
    end

    subgraph "VBA-stdError-Wrapper"
        VSE[main.ts]
        VSE_JS[main.js]
        VSE_PKG[package.json]
    end

    subgraph "Node.js Dependencies"
        TS[TypeScript 5.8.3]
        TSN[ts-node 10.9.2]
        TYPES["@types/node"]
    end

    subgraph "Python Dependencies"
        VBA_PRE[vba_precompiler]
    end

    VBD --> VBD_JS
    VBD_PKG --> TS
    VBD_PKG --> TSN
    VBD_PKG --> TYPES

    VSE --> VSE_JS
    VSE_PKG --> TS
    VSE_PKG --> TSN
    VSE_PKG --> TYPES
```
