# インフラ設計書

## 概要

本ドキュメントは、stdVBA（VBA Standard Library）プロジェクトのインフラストラクチャ構成を定義する設計書です。stdVBAはVBAライブラリプロジェクトであり、従来のサーバーベースのWebアプリケーションとは異なり、主にGitHub上でホストされ、GitHub ActionsによるCI/CDパイプラインを使用しています。

## システム構成

### 全体構成

stdVBAは以下の構成要素から成り立っています：

1. **ソースコードリポジトリ**: GitHub上でホストされるVBAソースコード（.cls, .bas, .frm）
2. **CI/CDパイプライン**: GitHub Actionsによる自動化処理
3. **ドキュメントホスティング**: GitHub Pagesによるドキュメント配信
4. **開発支援ツール**: TypeScript/Node.jsベースのユーティリティ

```
[開発者] --> [GitHub Repository] --> [GitHub Actions] --> [GitHub Pages]
                |                          |
                v                          v
         [VBA Source Code]         [自動化処理]
         (.cls, .bas, .frm)        - ドキュメント生成
                                   - Lint/静的解析
                                   - CRLF正規化
                                   - stdErrorラッパー生成
```

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| GitHub Actions Runner | CI/CDジョブ実行 | ubuntu-latest（GitHub提供） | 動的割当 |

**注記**: 本プロジェクトはVBAライブラリであり、独自のサーバー（Web、AP、DB）は使用しません。すべての処理はGitHub提供のインフラストラクチャ上で実行されます。

### ネットワーク構成

stdVBAプロジェクトは外部公開されているOSSプロジェクトであり、以下のネットワーク構成を持ちます：

- **プロトコル**: HTTPS
- **ホスティング**: GitHub（github.com）
- **エンドポイント**:
  - リポジトリ: `https://github.com/sancarn/stdVBA`
  - ドキュメント: GitHub Pages経由（`_config.yml`で設定）

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Node.js | 20.x | ドキュメント生成・stdErrorラッパーツール実行 |
| Python | 3.x（latest） | VBA PrecompilerによるLint前処理 |
| TypeScript | 5.8.3 | 開発ツール（VBDocsGen、VBA-stdError-Wrapper） |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理、CI/CD | HTTPS/Git |
| GitHub Actions | CI/CDパイプライン | GitHub API |
| GitHub Pages | ドキュメントホスティング | HTTPS |
| PyPI | Python依存関係（vba_precompiler） | HTTPS |
| npm | Node.js依存関係 | HTTPS |

## CI/CDパイプライン設計

### ワークフロー一覧

| ワークフロー名 | トリガー | 目的 |
| --- | --- | --- |
| `lint_vba.yml` | push（lintingブランチ） | VBAコードの静的解析・Lint |
| `vba_docs_gen.yml` | push | ドキュメント自動生成（docs.json） |
| `enforce_crlf.yml` | push/PR（masterブランチ） | VBAファイルのCRLF改行コード正規化 |
| `stdError_wrap.yml` | push（masterブランチ）/手動 | stdErrorによるエラーハンドリングラッパー生成 |

### ワークフロー詳細

#### 1. Lint VBA（`lint_vba.yml`）

```yaml
実行環境: ubuntu-latest
実行条件: lintingブランチへのpush
処理内容:
  1. Python依存関係インストール（vba_precompiler）
  2. VBAプリコンパイル（-v7 -sWin64）
  3. Vba-actions/lint-vbaによるLint実行
```

#### 2. VBA Docs Generator（`vba_docs_gen.yml`）

```yaml
実行環境: ubuntu-latest
実行条件: 全ブランチへのpush
処理内容:
  1. Node.js 20セットアップ
  2. VBDocsGenツール実行
  3. docs.json自動コミット・プッシュ
```

#### 3. Enforce CRLF（`enforce_crlf.yml`）

```yaml
実行環境: ubuntu-latest
実行条件: masterブランチへのpush/PR
権限: contents: write
処理内容:
  1. .bas, .frm, .clsファイルのCRLF正規化
  2. 変更があれば自動コミット・プッシュ
```

#### 4. stdError Wrapper（`stdError_wrap.yml`）

```yaml
実行環境: ubuntu-latest
実行条件: masterブランチへのpush、手動実行
権限: contents: write
処理内容:
  1. Node.js 20セットアップ
  2. VBA-stdError-Wrapperツール実行
  3. stdError-Wrappedブランチへフォースプッシュ
```

## スケーリング設計

本プロジェクトはVBAライブラリであり、従来のスケーリング概念は適用されません。

- **CI/CDスケーリング**: GitHub Actionsが自動的にRunnerを動的に割り当て
- **ドキュメントスケーリング**: GitHub Pagesのグローバル CDNにより自動スケーリング

## 可用性設計

| 対象 | 方式 | SLA |
| --- | --- | --- |
| GitHub Repository | GitHub提供の冗長構成 | 99.9%（GitHub SLA） |
| GitHub Actions | GitHub提供のマネージドサービス | 99.9%（GitHub SLA） |
| GitHub Pages | GitHub提供のCDN | 99.9%（GitHub SLA） |

**フェイルオーバー**:
- GitHub Actionsジョブ失敗時は自動リトライは行わず、手動での再実行が必要
- すべてのインフラはGitHub管理のため、個別のフェイルオーバー設計は不要

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git分散管理 | コミット毎 | 永続 |
| ビルド成果物 | GitHub Artifacts | ワークフロー実行毎 | 90日（GitHub既定） |
| ドキュメント | docs.jsonとしてリポジトリ内に保存 | 生成毎 | 永続（Git履歴） |

**復旧方法**:
- Gitの分散特性により、クローンを持つ任意の開発者からリポジトリ復旧が可能
- 特定バージョンへのロールバックは `git revert` または `git reset` で実施

## 監視設計

### CI/CD監視

| 監視対象 | 方式 | 通知 |
| --- | --- | --- |
| GitHub Actionsワークフロー | GitHub UI/API | GitHub通知、メール |
| ビルド失敗 | GitHub Actions | Pull Request上のステータスチェック |

### リポジトリ監視

- **アクティビティ監視**: GitHub Insights（コミット頻度、コントリビューター等）
- **セキュリティ監視**: GitHub Dependabot（依存関係脆弱性）

## 開発ツール構成

### VBDocsGen

```
パス: Tools/VBDocsGen/
言語: TypeScript
依存: @types/node, ts-node, typescript
用途: VBAソースコードからドキュメント（docs.json）を生成
```

### VBA-stdError-Wrapper

```
パス: Tools/VBA-stdError-Wrapper/
言語: TypeScript
依存: @types/node, ts-node, typescript
用途: VBAコードにstdErrorによるエラーハンドリングを自動付与
```

### VBALibraries Extract

```
パス: Tools/VBALibraries Extract/
言語: AutoHotkey
用途: VBAライブラリ情報の抽出・JSON出力
```

## 備考

### プロジェクト特性

1. **VBAライブラリプロジェクト**: サーバーサイドのインフラは存在せず、GitHubのマネージドサービスのみを使用
2. **開発者ローカル環境依存**: VBAコードの実行はMicrosoft Office（Excel等）上で行われ、サーバーでのホスティングは不要
3. **OSSプロジェクト**: MITライセンスで公開されており、誰でも自由にクローン・フォーク可能

### 将来の拡張ポイント

- GitHub ActionsのSelf-Hosted Runnerによるカスタム実行環境の導入（必要に応じて）
- GitHub Packagesへの成果物公開（npm等）
- ドキュメントサイトの独立したホスティング（Netlify、Vercel等への移行）
