---
generated_at: 2026-01-15 20:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 21
  claims_without_evidence: 4
confidence_derived: 0.84
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.84**
  - 根拠あり：21 / 25、根拠なし：4
- 優先レビュー（高）
  1. **HSTSの設定**: WinHTTPのデフォルト動作に関する公式ドキュメント未確認
  2. **証明書失効チェックのデフォルト値**: コード上では明示的に設定、デフォルト動作は要確認
  3. **stdErrorのスタックトレース機能**: WIPフォルダ内のコードのみ確認、完成度不明
  4. **IE11以上の要件**: WebSocket実装の最小要件は推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdHTTP.cls` - HTTP通信クラス
- E-02: `src/stdHTTPAuthenticators.bas` - HTTP認証モジュール
- E-03: `src/stdProcess.cls` - プロセス管理クラス
- E-04: `src/stdReg.cls` - レジストリ操作クラス
- E-05: `src/stdWebSocket.cls` - WebSocket通信クラス
- E-06: `src/stdJSON.cls` - JSONパーサークラス
- E-07: `src/stdRegex.cls` - 正規表現クラス
- E-08: `src/WIP/stdCrypto/stdCrypt.cls` - 暗号化クラス（WIP）
- E-09: `src/WIP/stdCrypto/MD5.cls` - MD5ハッシュクラス（WIP）
- E-10: `src/WIP/stdError/stdError.cls` - エラーハンドリングクラス（WIP）
- E-11: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows認証（WindowsAuthenticator）の実装 | E-02 (19-24行目) | ○ |
| C-02 | Basic認証（HttpBasicAuthenticator）の実装 | E-02 (26-41行目) | ○ |
| C-03 | Token認証（TokenAuthenticator）の実装 | E-02 (43-56行目) | ○ |
| C-04 | Digest認証はWIP状態 | E-02 (59-86行目, 73行目 Err.Raise) | ○ |
| C-05 | stdProcessでPROCESS_QUERY_INFORMATION権限を使用 | E-03 (358行目) | ○ |
| C-06 | stdProcessでPROCESS_TERMINATE権限を使用 | E-03 (508行目) | ○ |
| C-07 | stdRegでデフォルトPERM_READ権限 | E-04 (177行目) | ○ |
| C-08 | stdHTTPでWinHTTP.WinHttpRequest.5.1を使用 | E-01 (497行目) | ○ |
| C-09 | EnableCertificateRevocationCheckオプションの存在 | E-01 (517-521行目) | ○ |
| C-10 | Insecureオプションで証明書検証を無効化可能 | E-01 (516-524行目) | ○ |
| C-11 | EnableHttpsToHttpRedirectsデフォルト無効 | E-01 (523行目) | ○ |
| C-12 | stdWebSocketでwss://プロトコルサポート | E-05 (67行目, Create関数のurl引数) | ○ |
| C-13 | stdWebSocketでIE COMオブジェクトを使用 | E-05 (80行目) | ○ |
| C-14 | stdCryptでCryptProtectData/CryptUnprotectData使用 | E-08 (23-24行目) | ○ |
| C-15 | MD5ハッシュでCryptoAPI使用 | E-09 (17-30行目) | ○ |
| C-16 | stdJSONでパース時にErr.Raiseでエラー発生 | E-06 (139行目, 779行目) | ○ |
| C-17 | stdRegexでVBScript.RegExpをラップ | E-07 (158-161行目, 203行目) | ○ |
| C-18 | stdRegでnormalisePathオプション存在 | E-04 (177行目, 210行目) | ○ |
| C-19 | Basic認証はHTTPS推奨（コードコメント） | E-02 (37行目) | ○ |
| C-20 | stdProcess.CreateでShell関数を使用 | E-03 (261行目) | ○ |
| C-21 | stdErrorでスタックトレース機能提供予定 | E-10, E-11 (141行目 README) | ○ |
| C-22 | HSTSはWinHTTPデフォルト動作に依存 | **根拠なし** | △ |
| C-23 | 証明書検証のデフォルト有効 | **根拠不足** | △ |
| C-24 | IE11以上がWebSocket通信の要件 | **根拠なし** | △ |
| C-25 | stdCryptとMD5がWIP状態 | E-08, E-09 (WIPフォルダ内) | ○ |

## 4) 不足情報（Unknown / Missing）
- **HSTS設定**: WinHTTPのHSTS対応に関するMicrosoft公式ドキュメントの確認が必要
  - 候補：Microsoft WinHTTP Documentation / Windows SDK Documentation
- **証明書検証デフォルト値**: WinHttpRequestオブジェクトの初期状態の確認が必要
  - 候補：MSDN WinHttpRequest Reference
- **IE最小バージョン要件**: WebSocket APIのIEサポートバージョンの確認が必要
  - 候補：MDN Web Docs / Microsoft IE Documentation
- **セキュリティ監査要件**: 運用時の監査ログ要件についての定義が存在しない
  - 候補：プロジェクト要件定義書（未発見）

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: Basic認証がHTTP通信でも使用可能な設計（HTTPSの強制がない）
- **1（中リスク）**: stdWebSocketがIE COMオブジェクトに依存（IE非推奨化の影響）
- **0（低リスク）**: stdCrypt/MD5がWIP状態で本番使用には不適
- **0（低リスク）**: コマンドインジェクション対策は利用者責務（ライブラリとして妥当）

## 6) レビュアーチェックリスト（最小）
- [ ] C-22: HSTSに関する主張がWinHTTPの実際の動作と一致するか確認
- [ ] C-23: WinHttpRequestオブジェクトの証明書検証デフォルト値を確認
- [ ] C-24: stdWebSocketが動作するIEの最小バージョンを確認
- [ ] Basic認証のHTTPS強制が必要かプロジェクト方針として確認
- [ ] stdWebSocketのIE依存について、代替実装（WIP/stdWebSocket/）の完成度を確認
- [ ] WIPフォルダ内のセキュリティ機能（stdCrypt, MD5, stdError）の本番利用可否を判断
