# セキュリティ設計書

## 概要

本ドキュメントは、stdVBA（VBA Standard Library）プロジェクトのセキュリティ設計について記述します。stdVBAはVBAアプリケーション開発のための標準ライブラリ集であり、HTTP通信、暗号化、プロセス管理、レジストリ操作などのセキュリティに関連する機能を提供しています。

**注意**: 本プロジェクトはVBAライブラリであり、Webアプリケーションではないため、従来のWebセキュリティ（セッション管理、CSRF、XSS等）は直接適用されません。代わりに、ライブラリ利用者が安全にこれらの機能を使用するための設計方針を記載します。

## 認証設計

### 認証方式

stdVBAでは、HTTP通信（stdHTTP）における認証機能を提供しています。

| 認証方式 | 実装クラス/モジュール | 説明 |
| --- | --- | --- |
| Windows認証 | `stdHTTPAuthenticators.WindowsAuthenticator` | Windowsログオン資格情報を使用した自動認証 |
| Basic認証 | `stdHTTPAuthenticators.HttpBasicAuthenticator` | ユーザー名/パスワードによる基本認証（HTTPS推奨） |
| Token認証 | `stdHTTPAuthenticators.TokenAuthenticator` | カスタムヘッダーによるトークンベース認証 |
| Digest認証 | `stdHTTPAuthenticators.DigestAuthenticator` | チャレンジ/レスポンス型認証（WIP） |

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッション有効期限 | 該当なし | VBAライブラリのため、セッション管理は呼び出し元アプリケーションの責務 |
| セッション固定化対策 | 該当なし | HTTPリクエストごとに新規接続を確立 |

## 認可設計

### 権限体系

本プロジェクトはVBAライブラリであり、アプリケーションレベルの認可機能は提供していません。以下はOS/システムレベルの権限に関する設計です。

| ロール | 権限 | 説明 |
| --- | --- | --- |
| 標準ユーザー | PROCESS_QUERY_INFORMATION | プロセス情報の参照が可能（stdProcess） |
| 標準ユーザー | PERM_READ | レジストリの読み取りが可能（stdReg） |
| 管理者 | PROCESS_TERMINATE | プロセスの強制終了が可能（stdProcess.forceQuit） |
| 管理者 | PERM_WRITE, PERM_ALL_ACCESS | レジストリの書き込みが可能（stdReg） |

### アクセス制御

各クラスで最小権限の原則に基づいたアクセス制御を実装しています。

- **stdProcess**: 必要な操作に応じて最小限の権限（EProcessAccess）でプロセスハンドルを取得
- **stdReg**: デフォルトでPERM_READ権限、書き込み時のみPERM_WRITE権限を要求
- **stdHTTP**: プロキシ認証時のみ資格情報を設定

## 通信セキュリティ

### HTTP通信（stdHTTP）

| 項目 | 対策 |
| --- | --- |
| HTTPS | WinHTTP.WinHttpRequest.5.1を使用、SSL/TLS通信をサポート |
| HSTS | WinHTTPのデフォルト動作に依存（OS設定） |
| 証明書検証 | `EnableCertificateRevocationCheck`オプションで証明書失効チェックを有効化（デフォルト：有効） |
| 非セキュアモード | `Insecure`オプションでSSLエラー無視が可能（開発用途のみ推奨） |
| リダイレクト制御 | `EnableRedirects`オプションでリダイレクトの許可/禁止を制御 |
| HTTPS→HTTPリダイレクト | デフォルトで無効（`EnableHttpsToHttpRedirects = False`） |

### WebSocket通信（stdWebSocket）

| 項目 | 対策 |
| --- | --- |
| WSS対応 | `wss://`プロトコルをサポート |
| 実装基盤 | Internet Explorer COMオブジェクトを使用（IE11のセキュリティ設定に依存） |
| 通信暗号化 | wss://使用時はTLS暗号化が適用 |

## データセキュリティ

### 暗号化

| 対象 | 暗号化方式 |
| --- | --- |
| 通信 | TLS/SSL（WinHTTPのデフォルト実装に依存） |
| 保存データ | Windows DPAPI（CryptProtectData/CryptUnprotectData）- stdCrypt（WIP） |
| ハッシュ | MD5ハッシュ（CryptoAPI - MD5.cls、WIP） |

### 機密情報管理

- **資格情報**: stdHTTPAuthenticatorsでは資格情報をメモリ上で保持し、リクエスト完了後に解放
- **セキュア通信**: Basic認証はHTTPSでのみ使用を推奨（コードコメントに明記）
- **プロキシ認証**: プロキシ資格情報は一時的なDictinaryオブジェクトで保持

## 入出力対策

| 脅威 | 対策 |
| --- | --- |
| XSS | 該当なし（VBAライブラリ、Web UIなし） |
| SQLインジェクション | 該当なし（データベース接続機能なし） |
| CSRF | 該当なし（Web UIなし） |
| コマンドインジェクション | stdProcess.Createは直接Shell関数を使用、入力値の検証は呼び出し元の責務 |
| JSONパースエラー | stdJSONでパース時にエラーハンドリングを実装、不正な入力に対してErr.Raiseで例外を発生 |
| 正規表現ReDoS | stdRegexはVBScript.RegExpをラップ、複雑なパターンでのDoS攻撃リスクあり（利用者が注意） |

### 入力検証

| 機能 | 検証内容 |
| --- | --- |
| stdHTTP URL | WinHTTPによるURL形式検証 |
| stdJSON | JSONパーサーによる構文検証、不正形式でエラー発生 |
| stdRegex | VBScript.RegExpによるパターン検証 |
| stdReg パス | レジストリパスの正規化オプション（`normalisePath`） |

## 監査ログ

| ログ種別 | 記録内容 | 保持期間 |
| --- | --- | --- |
| デバッグログ | stdProcess操作エラー、stdHTTP通信エラー | 実行時のみ（Debug.Print） |
| システムログ | 該当なし（VBAライブラリでは独自ログ機能を提供しない） |

**備考**: stdVBAはライブラリであるため、監査ログ機能は呼び出し元アプリケーションで実装することを推奨します。stdError（WIP）クラスでエラートラッキング機能の提供を予定しています。

## 備考

### セキュリティ上の注意事項

1. **Basic認証**: `stdHTTPAuthenticators.HttpBasicAuthenticator`は資格情報を平文で送信するため、HTTPS通信でのみ使用してください
2. **Insecureオプション**: `stdHTTP.CreateOptions(Insecure:=True)`は証明書検証を無効化するため、本番環境では使用しないでください
3. **プロセス操作**: `stdProcess.forceQuit`は強制終了のため、データ損失の可能性があります
4. **レジストリ書き込み**: `stdReg`での書き込み操作はシステムに影響を与える可能性があるため、慎重に使用してください

### WIP（開発中）のセキュリティ機能

- **stdCrypt**: Windows DPAPIを使用した暗号化/復号化機能
- **stdError**: スタックトレース付きエラーハンドリング
- **DigestAuthenticator**: HTTP Digest認証の完全実装

### 依存コンポーネント

| コンポーネント | バージョン | 用途 |
| --- | --- | --- |
| WinHTTP | 5.1 | HTTP/HTTPS通信 |
| CryptoAPI (advapi32.dll) | Windows標準 | 暗号化、ハッシュ |
| VBScript.RegExp | Windows標準 | 正規表現処理 |
| Internet Explorer | 11以上 | WebSocket通信 |
