---
generated_at: 2026-01-15 18:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な目標値がコード上に存在しない
  2. **受入テストの担当**：エンドユーザー担当の記載は推測
  3. **性能テスト実施タイミング**：定期的・リリース前は一般的な推奨であり明示的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tests/Main.bas` - メインテストエントリーポイント
- E-02: `tests/lib/Test.cls` - テストフレームワーク実装
- E-03: `tests/stdArrayTests.bas` - stdArrayテスト実装
- E-04: `tests/stdLambdaTests.bas` - stdLambdaテスト実装
- E-05: `tests/stdEnumeratorTests.bas` - stdEnumeratorテスト実装
- E-06: `tests/stdHTTPTests.bas` - stdHTTPテスト実装
- E-07: `.github/workflows/lint_vba.yml` - Linting CI設定
- E-08: `.github/workflows/enforce_crlf.yml` - CRLF強制CI設定
- E-09: `.github/workflows/vba_docs_gen.yml` - ドキュメント生成CI設定
- E-10: `.github/workflows/stdError_wrap.yml` - stdErrorラッパーCI設定
- E-11: `README.md` - プロジェクト概要・ロードマップ
- E-12: `contribution.md` - 貢献者ガイドライン
- E-13: `testBuilder.xlsm` - テストビルダーファイル
- E-14: `fullBuild.xlsm` - フルビルドファイル
- E-15: `tests/` ディレクトリ構成 - 17テストファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Test.clsがカスタムテストフレームワークとして機能 | E-02 | ○ |
| C-02 | Test.Refresh, Test.Topic, Test.Assertメソッドの存在 | E-02 | ○ |
| C-03 | Test.FullTestプロパティによるテストモード切替 | E-02, E-04 | ○ |
| C-04 | GetTickCountによる実行時間計測 | E-02 | ○ |
| C-05 | 13クラスに対応するテストファイルが存在 | E-01, E-15 | ○ |
| C-06 | MainTestAllが全テストを呼び出す | E-01 | ○ |
| C-07 | vba_precompilerを使用した前処理 | E-07 | ○ |
| C-08 | lint-vbaアクションによる静的解析 | E-07 | ○ |
| C-09 | CRLF強制ワークフローの存在 | E-08 | ○ |
| C-10 | ドキュメント生成ワークフローの存在 | E-09 | ○ |
| C-11 | stdErrorラッピングワークフローの存在 | E-10 | ○ |
| C-12 | postman-echo.comを使用したHTTPテスト | E-06 | ○ |
| C-13 | stdLambdaのパフォーマンスキャッシュテスト | E-04 | ○ |
| C-14 | GitHub Issuesでの不具合管理 | E-11 | ○ |
| C-15 | changelog.mdでの変更履歴管理 | E-12 | ○ |
| C-16 | PredeclaredIdパターンの使用 | E-12 | ○ |
| C-17 | Mac/Windows両対応のAPI宣言 | E-02 | ○ |
| C-18 | 32bit/64bit両対応（VBA7対応） | E-02 | ○ |
| C-19 | testBuilder.xlsmの存在 | E-13 | ○ |
| C-20 | fullBuild.xlsmの存在 | E-14 | ○ |
| C-21 | ListObjectとConditional Formattingによる結果表示 | E-02 | ○ |
| C-22 | stdICallableインターフェースの使用 | E-04 | ○ |
| C-23 | Collection/Dictionaryを使用したテストデータ生成 | E-03, E-05 | ○ |
| C-24 | Node.js 20によるドキュメント生成 | E-09 | ○ |
| C-25 | WIPディレクトリの解析除外 | E-07 | ○ |
| C-26 | カバレッジ目標値が明示されていない | **根拠なし** | △ |
| C-27 | 受入テストの担当がエンドユーザー | **根拠なし** | △ |
| C-28 | 性能テストの実施タイミング（定期的・リリース前） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標**: プロジェクト内にカバレッジ目標を定義した設定ファイルや文書が見つからない。VBAの特性上、自動カバレッジ計測が困難であるため、目標値が設定されていない可能性が高い。
  - 候補：プロジェクト管理文書 / テスト方針定義文書 / GitHub Wiki
- **受入テスト担当**: contribution.mdや README.mdに受入テストの担当者に関する記載がない。「エンドユーザー」は一般的な慣行に基づく推測。
  - 候補：CONTRIBUTING.md / テストガイドライン / GitHub Discussions
- **性能テスト実施タイミング**: CI/CDワークフローに性能テストの定期実行設定がない。「定期的・リリース前」は一般的なベストプラクティスに基づく記載。
  - 候補：GitHub Actions スケジュールワークフロー / リリース手順書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - テストフレームワーク（Test.cls）の機能に関する記載
- **0: 低リスク** - CI/CDワークフローの設定内容
- **0: 低リスク** - テスト対象クラスの一覧
- **1: 中リスク** - カバレッジ目標の記載（明示的根拠なし、ただし「目標値なし」と正直に記載）
- **1: 中リスク** - テストモード（FullTest/QuickTest）の運用方針
- **0: 低リスク** - GitHub Issuesでの不具合管理

## 6) レビュアーチェックリスト（最小）
- [ ] Test.clsの実装内容が正確に記載されているか確認
- [ ] GitHub Actionsワークフローの内容が最新か確認
- [ ] テスト対象クラスの一覧に漏れがないか確認
- [ ] カバレッジ目標について、プロジェクトオーナーに確認が必要か判断
- [ ] 性能テストの実際の運用方針について開発者に確認
- [ ] Mac/Windows対応の記載がTest.cls以外のファイルでも確認できるか
